/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.tasks.TrailerDownloadTask;
import org.tinymediamanager.core.tasks.YTDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;

public class TvShowHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShow.class);

    private TvShowHelpers() {
    }

    public static MediaCertification parseCertificationStringForTvShowSetupCountry(String name) {
        MediaCertification cert = MediaCertification.UNKNOWN;
        if ((name = name.trim()).contains("/")) {
            String[] cs;
            String[] countries;
            for (String c : countries = name.split("/")) {
                if ((c = c.trim()).contains(":")) {
                    cs = c.split(":");
                    cert = MediaCertification.getCertification(TvShowModuleManager.SETTINGS.getCertificationCountry(), cs[1]);
                    if (cert == MediaCertification.UNKNOWN) continue;
                    return cert;
                }
                cert = MediaCertification.getCertification(TvShowModuleManager.SETTINGS.getCertificationCountry(), c);
                if (cert == MediaCertification.UNKNOWN) continue;
                return cert;
            }
            for (String c : countries) {
                if (!((c = c.trim()).contains(":") ? (cert = MediaCertification.findCertification((cs = c.split(":"))[1])) != MediaCertification.UNKNOWN : (cert = MediaCertification.findCertification(c)) != MediaCertification.UNKNOWN)) continue;
                return cert;
            }
        } else if (name.contains(":")) {
            String[] cs = name.split(":");
            cert = MediaCertification.getCertification(TvShowModuleManager.SETTINGS.getCertificationCountry(), cs[1].trim());
            if (cert == MediaCertification.UNKNOWN) {
                cert = MediaCertification.findCertification(cs[1].trim());
            }
        } else {
            cert = MediaCertification.getCertification(TvShowModuleManager.SETTINGS.getCertificationCountry(), name.trim());
        }
        if (cert == MediaCertification.UNKNOWN) {
            cert = MediaCertification.findCertification(name);
        }
        return cert;
    }

    public static String detectSeasonFolder(TvShow tvShow, int season) {
        ArrayList<String> subPaths = new ArrayList<String>();
        Path tvShowPath = tvShow.getPathNIO();
        List<TvShowEpisode> episodes = tvShow.getEpisodesForSeason(season);
        try {
            for (TvShowEpisode episode : episodes) {
                Path videoFilePath = episode.getMainVideoFile().getFileAsPath().getParent();
                Path relativePath = tvShowPath.relativize(videoFilePath);
                int subfolders = relativePath.getNameCount();
                for (int i = 1; i <= subfolders; ++i) {
                    subPaths.add(relativePath.subpath(0, i).toString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not extract season folder: {}", (Object)e.getMessage());
        }
        if (subPaths.isEmpty()) {
            return "";
        }
        Map<String, Long> subPathCounts = subPaths.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting()));
        Map.Entry entry = subPathCounts.entrySet().stream().max(Comparator.comparing(Map.Entry::getValue)).get();
        if ((double)((Long)entry.getValue()).longValue() >= 0.8 * (double)episodes.size()) {
            return (String)entry.getKey();
        }
        TvShowEpisode episode = new TvShowEpisode();
        episode.setSeason(season);
        return TvShowRenamer.getSeasonFoldername(tvShow, episode);
    }

    public static void startAutomaticTrailerDownload(TvShow tvShow) {
        if (TvShowModuleManager.SETTINGS.isUseTrailerPreference() && TvShowModuleManager.SETTINGS.isAutomaticTrailerDownload() && tvShow.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !tvShow.getTrailer().isEmpty()) {
            TvShowHelpers.downloadBestTrailer(tvShow);
        }
    }

    public static void downloadBestTrailer(TvShow tvShow) {
        MediaTrailer trailer = tvShow.getTrailer().get(0);
        TvShowHelpers.downloadTrailer(tvShow, trailer);
    }

    public static void downloadTrailer(final TvShow tvshow, MediaTrailer trailer) {
        List<TvShowTrailerNaming> trailernames = TvShowModuleManager.SETTINGS.getTrailerFilenames();
        final String filename = !trailernames.isEmpty() ? tvshow.getTrailerFilename(trailernames.get(0)) : tvshow.getTrailerFilename(TvShowTrailerNaming.TVSHOW_TRAILER);
        try {
            Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(trailer.getUrl());
            if (matcher.matches()) {
                YTDownloadTask task = new YTDownloadTask(trailer, TvShowModuleManager.SETTINGS.getTrailerQuality()){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return tvshow.getPathNIO().resolve(filename);
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return tvshow;
                    }
                };
                TmmTaskManager.getInstance().addDownloadTask(task);
            } else {
                TrailerDownloadTask task = new TrailerDownloadTask(trailer){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return tvshow.getPathNIO().resolve(filename);
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return tvshow;
                    }
                };
                TmmTaskManager.getInstance().addDownloadTask(task);
            }
        }
        catch (Exception e) {
            LOGGER.error("could not start trailer download: {}", (Object)e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvshow, "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
        }
    }
}

