/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.UTF8Control;

public enum TvShowEpisodeScraperMetadataConfig implements ScraperMetadataConfig
{
    TITLE(ScraperMetadataConfig.Type.METADATA),
    ORIGINAL_TITLE(ScraperMetadataConfig.Type.METADATA, "metatag.originaltitle"),
    PLOT(ScraperMetadataConfig.Type.METADATA),
    AIRED_SEASON_EPISODE(ScraperMetadataConfig.Type.METADATA, "tvshow.aired.seasonepisode"),
    DVD_SEASON_EPISODE(ScraperMetadataConfig.Type.METADATA, "tvshow.dvd.seasonepisode"),
    DISPLAY_SEASON_EPISODE(ScraperMetadataConfig.Type.METADATA, "tvshow.display.seasonepisode"),
    AIRED(ScraperMetadataConfig.Type.METADATA, "metatag.aired"),
    RATING(ScraperMetadataConfig.Type.METADATA),
    TAGS(ScraperMetadataConfig.Type.METADATA),
    ACTORS(ScraperMetadataConfig.Type.CAST),
    PRODUCERS(ScraperMetadataConfig.Type.CAST),
    DIRECTORS(ScraperMetadataConfig.Type.CAST),
    WRITERS(ScraperMetadataConfig.Type.CAST),
    THUMB(ScraperMetadataConfig.Type.ARTWORK);

    private static final ResourceBundle BUNDLE;
    private ScraperMetadataConfig.Type type;
    private String description;
    private String tooltip;

    private TvShowEpisodeScraperMetadataConfig(ScraperMetadataConfig.Type type) {
        this(type, null, null);
    }

    private TvShowEpisodeScraperMetadataConfig(ScraperMetadataConfig.Type type, String description) {
        this(type, description, null);
    }

    private TvShowEpisodeScraperMetadataConfig(ScraperMetadataConfig.Type type, String description, String tooltip) {
        this.type = type;
        this.description = description;
        this.tooltip = tooltip;
    }

    @Override
    public ScraperMetadataConfig.Type getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        if (StringUtils.isBlank((CharSequence)this.description)) {
            try {
                if (this.type == ScraperMetadataConfig.Type.ARTWORK) {
                    return BUNDLE.getString("mediafiletype." + this.name().toLowerCase(Locale.ROOT));
                }
                return BUNDLE.getString("metatag." + this.name().toLowerCase(Locale.ROOT));
            }
            catch (Exception exception) {}
        } else {
            try {
                return BUNDLE.getString(this.description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getToolTip() {
        if (StringUtils.isBlank((CharSequence)this.tooltip)) {
            return null;
        }
        try {
            return BUNDLE.getString(this.tooltip);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    }
}

