/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ResourceBundle;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.tasks.DownloadTask;

public abstract class TrailerDownloadTask
extends DownloadTask {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    private final MediaTrailer mediaTrailer;

    protected TrailerDownloadTask(MediaTrailer trailer) {
        super(BUNDLE.getString("trailer.download") + " - " + trailer.getName(), trailer.getUrl());
        this.mediaTrailer = trailer;
        this.setTaskDescription(trailer.getName());
    }

    @Override
    protected String getSpecialUserAgent() {
        if ("apple".equalsIgnoreCase(this.mediaTrailer.getProvider())) {
            return "QuickTime";
        }
        return null;
    }

    @Override
    protected void checkDownloadedFile() throws IOException {
        super.checkDownloadedFile();
        BasicFileAttributes view = Files.readAttributes(this.tempFile, BasicFileAttributes.class, new LinkOption[0]);
        if (view.size() < 1000000L) {
            this.cancel = true;
        }
    }
}

