/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class MediaFileInformationFetcherTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFileInformationFetcherTask.class);
    protected final MediaFile mediaFile;
    protected final MediaEntity mediaEntity;
    private final long uniqueId;
    private final boolean forceUpdate;

    public MediaFileInformationFetcherTask(MediaFile mediaFile, MediaEntity mediaEntity, boolean forceUpdate) {
        this.mediaFile = mediaFile;
        this.mediaEntity = mediaEntity;
        this.forceUpdate = forceUpdate;
        this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
    }

    @Override
    public void run() {
        try {
            String name = Thread.currentThread().getName();
            if (!name.contains("-G")) {
                name = name + "-G0";
            }
            name = name.replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName(name);
            this.mediaFile.gatherMediaInformation(this.forceUpdate);
            if (this.mediaEntity instanceof Movie && this.mediaFile.hasSubtitles()) {
                Movie movie = (Movie)this.mediaEntity;
                movie.firePropertyChange("hasSubtitles", false, true);
            }
            if (this.mediaEntity instanceof TvShowEpisode && this.mediaFile.hasSubtitles()) {
                TvShowEpisode episode = (TvShowEpisode)this.mediaEntity;
                episode.firePropertyChange("hasSubtitles", false, true);
            }
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed: ", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MediaInformation", "message.mediainfo.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
        }
        this.callback();
        if (this.mediaEntity != null) {
            this.mediaEntity.callbackForGatheredMediainformation(this.mediaFile);
            this.mediaEntity.saveToDb();
            this.mediaEntity.firePropertyChange("mediaInformation", false, true);
            return;
        }
    }

    public void callback() {
    }
}

