/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.io.InterruptedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class MediaEntityImageFetcherTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaEntityImageFetcherTask.class);
    private MediaEntity entity;
    private String url;
    private MediaArtwork.MediaArtworkType type;
    private String filename;
    private boolean firstImage;

    public MediaEntityImageFetcherTask(MediaEntity entity, String url, MediaArtwork.MediaArtworkType type, String filename, boolean firstImage) {
        this.entity = entity;
        this.url = url;
        this.type = type;
        this.filename = filename;
        this.firstImage = firstImage;
    }

    @Override
    public void run() {
        block16: {
            if (StringUtils.isBlank((CharSequence)this.filename)) {
                return;
            }
            String oldFilename = null;
            try {
                if (this.firstImage) {
                    switch (this.type) {
                        case POSTER: 
                        case BACKGROUND: 
                        case BANNER: 
                        case THUMB: 
                        case CLEARART: 
                        case DISC: 
                        case LOGO: 
                        case CLEARLOGO: 
                        case CHARACTERART: 
                        case KEYART: {
                            oldFilename = this.entity.getArtworkFilename(MediaFileType.getMediaFileType(this.type));
                            this.entity.removeAllMediaFiles(MediaFileType.getMediaFileType(this.type));
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                LOGGER.debug("writing {} - {}", (Object)this.type, (Object)this.filename);
                Path destFile = ImageUtils.downloadImage(this.url, this.entity.getPathNIO(), this.filename);
                if (this.firstImage) {
                    LOGGER.debug("set {} - {}", (Object)this.type, (Object)FilenameUtils.getName((String)this.filename));
                    ImageCache.invalidateCachedImage(this.entity.getPathNIO().resolve(this.filename));
                    switch (this.type) {
                        case POSTER: 
                        case BACKGROUND: 
                        case BANNER: 
                        case THUMB: 
                        case CLEARART: 
                        case DISC: 
                        case LOGO: 
                        case CLEARLOGO: 
                        case CHARACTERART: 
                        case KEYART: {
                            this.entity.setArtwork(destFile, MediaFileType.getMediaFileType(this.type));
                            this.entity.callbackForWrittenArtwork(this.type);
                            this.entity.saveToDb();
                            ImageCache.cacheImageSilently(destFile);
                            break block16;
                        }
                        default: {
                            return;
                        }
                    }
                }
                MediaFile artwork = new MediaFile(destFile, MediaFileType.getMediaFileType(this.type));
                artwork.gatherMediaInformation();
                this.entity.addToMediaFiles(artwork);
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("fetch image {} - {}", (Object)this.url, (Object)e.getMessage());
                if (this.firstImage && StringUtils.isNotBlank(oldFilename)) {
                    switch (this.type) {
                        case POSTER: 
                        case BACKGROUND: 
                        case BANNER: 
                        case THUMB: 
                        case CLEARART: 
                        case DISC: 
                        case LOGO: 
                        case CLEARLOGO: 
                        case CHARACTERART: 
                        case KEYART: {
                            Path oldFile = Paths.get(oldFilename, new String[0]);
                            this.entity.setArtwork(oldFile, MediaFileType.getMediaFileType(this.type));
                            this.entity.callbackForWrittenArtwork(this.type);
                            this.entity.saveToDb();
                            ImageCache.cacheImageSilently(oldFile);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"ArtworkDownload", "message.artwork.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

