/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmThreadPool;

public class MovieReloadMediaInformationTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieReloadMediaInformationTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<Movie> moviesToReload;

    public MovieReloadMediaInformationTask(List<Movie> movies) {
        super(BUNDLE.getString("movie.updatemediainfo"));
        this.moviesToReload = new ArrayList<Movie>(movies);
        this.initThreadPool(1, "reloadMI");
    }

    @Override
    protected void doInBackground() {
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            LOGGER.info("get MediaInfo...");
            this.start();
            for (Movie m : this.moviesToReload) {
                if (this.cancel) break;
                for (MediaFile mf : m.getMediaFiles()) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, m, true));
                }
            }
            this.waitForCompletionOrCancel();
            stopWatch.stop();
            LOGGER.info("Done getting MediaInfo - took {}", (Object)stopWatch);
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "MediaInfo", "message.mediainfo.threadcrashed"));
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }
}

