/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieGenericXmlConnector;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;
import org.tinymediamanager.core.movie.entities.Movie;
import org.w3c.dom.Element;

public class MovieToMpLegacyConnector
extends MovieGenericXmlConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieToMpLegacyConnector.class);

    public MovieToMpLegacyConnector(Movie movie) {
        super(movie);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void addOwnTags() {
    }

    @Override
    protected void addFanart() {
        Element fanart = this.document.createElement("fanart");
        String fanarUrl = this.movie.getArtworkUrl(MediaFileType.FANART);
        if (StringUtils.isNotBlank((CharSequence)fanarUrl)) {
            Element thumb = this.document.createElement("thumb");
            thumb.setTextContent(fanarUrl);
            fanart.appendChild(thumb);
        }
        this.root.appendChild(fanart);
    }

    @Override
    protected void addMpaa() {
    }

    @Override
    protected void addGenres() {
        Element genres = this.document.createElement("genres");
        for (MediaGenres mediaGenre : this.movie.getGenres()) {
            Element genre = this.document.createElement("genre");
            genre.setTextContent(mediaGenre.getLocalizedName(MovieModuleManager.SETTINGS.getNfoLanguage().toLocale()));
            genres.appendChild(genre);
        }
        this.root.appendChild(genres);
    }

    @Override
    protected void addCountry() {
        Element country = this.document.createElement("country");
        country.setTextContent(this.movie.getCountry());
        this.root.appendChild(country);
    }

    @Override
    protected void addStudios() {
        Element studio = this.document.createElement("studio");
        studio.setTextContent(this.movie.getProductionCompany());
        this.root.appendChild(studio);
    }

    @Override
    protected void addCredits() {
        Element credits = this.document.createElement("credits");
        credits.setTextContent(this.movie.getWritersAsString());
        this.root.appendChild(credits);
    }

    @Override
    protected void addDirectors() {
        Element director = this.document.createElement("director");
        director.setTextContent(this.movie.getDirectorsAsString());
        this.root.appendChild(director);
    }

    @Override
    protected void addLanguages() {
        Locale uiLanguage = Locale.getDefault();
        ArrayList<String> languages = new ArrayList<String>();
        for (String langu : MovieNfoParser.split(this.movie.getSpokenLanguages())) {
            Locale locale = new Locale(langu = langu.trim());
            String languageLocalized = locale.getDisplayLanguage(uiLanguage);
            if (StringUtils.isNotBlank((CharSequence)languageLocalized) && !langu.equalsIgnoreCase(languageLocalized)) {
                languages.add(languageLocalized);
                continue;
            }
            languages.add(langu);
        }
        Element element = this.document.createElement("languages");
        element.setTextContent(StringUtils.join(languages, (char)'|'));
        this.root.appendChild(element);
    }
}

