/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.nio.file.Path;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;

public enum MovieConnectors {
    KODI("Kodi"),
    XBMC("Kodi / XBMC < v16"),
    MP("MediaPortal (legacy)"),
    MP_MP("MediaPortal - Moving Pictures"),
    MP_MV("MediaPortal - MyVideo");

    private String title;

    private MovieConnectors(String title) {
        this.title = title;
    }

    public String toString() {
        return this.title;
    }

    public static boolean isValidNFO(Path nfo) {
        try {
            MovieNfoParser movieNfoParser = MovieNfoParser.parseNfo(nfo);
            return movieNfoParser.isValidNfo();
        }
        catch (Exception e) {
            return false;
        }
    }
}

