/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.observablecollections.ObservableCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.DateField;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.filenaming.MovieBannerNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearlogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieDiscartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieKeyartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieLogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.core.movie.filenaming.MoviePosterNaming;
import org.tinymediamanager.core.movie.filenaming.MovieThumbNaming;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;

public class MovieSettings
extends AbstractSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSettings.class);
    public static final String DEFAULT_RENAMER_FOLDER_PATTERN = "${title} ${- ,edition,} (${year})";
    public static final String DEFAULT_RENAMER_FILE_PATTERN = "${title} ${- ,edition,} (${year}) ${videoFormat} ${audioCodec}";
    private static final String CONFIG_FILE = "movies.json";
    private static MovieSettings instance;
    private static final String MOVIE_DATA_SOURCE = "movieDataSource";
    private static final String NFO_FILENAME = "nfoFilename";
    private static final String POSTER_FILENAME = "posterFilename";
    private static final String FANART_FILENAME = "fanartFilename";
    private static final String BANNER_FILENAME = "bannerFilename";
    private static final String CLEARART_FILENAME = "clearartFilename";
    private static final String THUMB_FILENAME = "thumbFilename";
    private static final String LOGO_FILENAME = "logoFilename";
    private static final String CLEARLOGO_FILENAME = "clearlogoFilename";
    private static final String DISCART_FILENAME = "discartFilename";
    private static final String KEYART_FILENAME = "keyartFilename";
    private static final String TRAILER_FILENAME = "trailerFilename";
    private static final String ARTWORK_SCRAPERS = "artworkScrapers";
    private static final String TRAILER_SCRAPERS = "trailerScrapers";
    private static final String SUBTITLE_SCRAPERS = "subtitleScrapers";
    private static final String BAD_WORD = "badWord";
    private static final String UI_FILTERS = "uiFilters";
    private static final String MOVIE_SET_UI_FILTERS = "movieSetUiFilters";
    private static final String SKIP_FOLDER = "skipFolder";
    private static final String CHECK_IMAGES_MOVIE = "checkImagesMovie";
    private final List<String> movieDataSources = ObservableCollections.observableList(new ArrayList());
    private final List<MovieNfoNaming> nfoFilenames = new ArrayList<MovieNfoNaming>();
    private final List<MoviePosterNaming> posterFilenames = new ArrayList<MoviePosterNaming>();
    private final List<MovieFanartNaming> fanartFilenames = new ArrayList<MovieFanartNaming>();
    private final List<MovieBannerNaming> bannerFilenames = new ArrayList<MovieBannerNaming>();
    private final List<MovieClearartNaming> clearartFilenames = new ArrayList<MovieClearartNaming>();
    private final List<MovieThumbNaming> thumbFilenames = new ArrayList<MovieThumbNaming>();
    private final List<MovieClearlogoNaming> clearlogoFilenames = new ArrayList<MovieClearlogoNaming>();
    private final List<MovieLogoNaming> logoFilenames = new ArrayList<MovieLogoNaming>();
    private final List<MovieDiscartNaming> discartFilenames = new ArrayList<MovieDiscartNaming>();
    private final List<MovieKeyartNaming> keyartFilenames = new ArrayList<MovieKeyartNaming>();
    private final List<MovieTrailerNaming> trailerFilenames = new ArrayList<MovieTrailerNaming>();
    private final List<MediaArtwork.MediaArtworkType> checkImagesMovie = new ArrayList<MediaArtwork.MediaArtworkType>();
    private final List<String> badWords = ObservableCollections.observableList(new ArrayList());
    private final List<String> artworkScrapers = ObservableCollections.observableList(new ArrayList());
    private final List<String> trailerScrapers = ObservableCollections.observableList(new ArrayList());
    private final List<String> subtitleScrapers = ObservableCollections.observableList(new ArrayList());
    private final List<String> skipFolders = ObservableCollections.observableList(new ArrayList());
    private final List<AbstractSettings.UIFilters> uiFilters = new ArrayList<AbstractSettings.UIFilters>();
    private final List<String> movieTableHiddenColumns = ObservableCollections.observableList(new ArrayList());
    private final List<AbstractSettings.UIFilters> movieSetUiFilters = new ArrayList<AbstractSettings.UIFilters>();
    private final List<String> movieSetTableHiddenColumns = ObservableCollections.observableList(new ArrayList());
    private boolean buildImageCacheOnImport = false;
    private MovieConnectors movieConnector = MovieConnectors.KODI;
    private CertificationStyle certificationStyle = CertificationStyle.LARGE;
    private boolean writeCleanNfo = false;
    private DateField nfoDateAddedField = DateField.DATE_ADDED;
    private MediaLanguages nfoLanguage = MediaLanguages.en;
    private boolean createOutline = true;
    private boolean outlineFirstSentence = false;
    private boolean renameAfterScrape = false;
    private String renamerPathname = "${title} ${- ,edition,} (${year})";
    private String renamerFilename = "${title} ${- ,edition,} (${year}) ${videoFormat} ${audioCodec}";
    private boolean renamerPathnameSpaceSubstitution = false;
    private String renamerPathnameSpaceReplacement = "_";
    private boolean renamerFilenameSpaceSubstitution = false;
    private String renamerFilenameSpaceReplacement = "_";
    private String renamerColonReplacement = "-";
    private boolean renamerNfoCleanup = false;
    private boolean renamerCreateMoviesetForSingleMovie = false;
    private boolean asciiReplacement = false;
    private String movieScraper = "tmdb";
    private MediaLanguages scraperLanguage = MediaLanguages.en;
    private CountryCode certificationCountry = CountryCode.US;
    private double scraperThreshold = 0.75;
    private boolean scraperFallback = false;
    private List<MovieScraperMetadataConfig> scraperMetadataConfig = new ArrayList<MovieScraperMetadataConfig>();
    private boolean capitalWordsInTitles = false;
    private MediaArtwork.PosterSizes imagePosterSize = MediaArtwork.PosterSizes.LARGE;
    private MediaArtwork.FanartSizes imageFanartSize = MediaArtwork.FanartSizes.LARGE;
    private boolean imageExtraThumbs = false;
    private boolean imageExtraThumbsResize = true;
    private int imageExtraThumbsSize = 300;
    private int imageExtraThumbsCount = 5;
    private boolean imageExtraFanart = false;
    private int imageExtraFanartCount = 5;
    private boolean enableMovieSetArtworkMovieFolder = true;
    private boolean enableMovieSetArtworkFolder = false;
    private String movieSetArtworkFolder = "MoviesetArtwork";
    private boolean movieSetArtworkFolderStyleKodi = true;
    private boolean movieSetArtworkFolderStyleAutomator = false;
    private boolean scrapeBestImage = true;
    private MediaLanguages imageScraperLanguage = MediaLanguages.en;
    private boolean imageLanguagePriority = true;
    private boolean writeActorImages = false;
    private boolean useTrailerPreference = true;
    private boolean automaticTrailerDownload = false;
    private TrailerQuality trailerQuality = TrailerQuality.HD_720;
    private TrailerSources trailerSource = TrailerSources.YOUTUBE;
    private MediaLanguages subtitleScraperLanguage = MediaLanguages.en;
    private LanguageStyle subtitleLanguageStyle = LanguageStyle.ISO3T;
    private boolean subtitleWithoutLanguageTag = false;
    private boolean runtimeFromMediaInfo = false;
    private boolean includeExternalAudioStreams = false;
    private boolean syncTrakt = false;
    private boolean preferPersonalRating = true;
    private String preferredRating = "imdb";
    private boolean extractArtworkFromVsmeta = false;
    private boolean storeUiFilters = false;
    private boolean showLogosPanel = true;

    public MovieSettings() {
        this.addDefaultEntries();
        this.addPropertyChangeListener(evt -> this.setDirty());
    }

    private void addDefaultEntries() {
        this.nfoFilenames.clear();
        this.addNfoFilename(MovieNfoNaming.MOVIE_NFO);
        this.posterFilenames.clear();
        this.addPosterFilename(MoviePosterNaming.POSTER);
        this.fanartFilenames.clear();
        this.addFanartFilename(MovieFanartNaming.FANART);
        this.bannerFilenames.clear();
        this.addBannerFilename(MovieBannerNaming.BANNER);
        this.clearartFilenames.clear();
        this.addClearartFilename(MovieClearartNaming.CLEARART);
        this.thumbFilenames.clear();
        this.addThumbFilename(MovieThumbNaming.THUMB);
        this.logoFilenames.clear();
        this.addLogoFilename(MovieLogoNaming.LOGO);
        this.clearlogoFilenames.clear();
        this.addClearlogoFilename(MovieClearlogoNaming.CLEARLOGO);
        this.discartFilenames.clear();
        this.addDiscartFilename(MovieDiscartNaming.DISC);
        this.keyartFilenames.clear();
        this.addKeyartFilename(MovieKeyartNaming.KEYART);
        this.trailerFilenames.clear();
        this.addTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        this.checkImagesMovie.clear();
        this.addCheckImagesMovie(MediaArtwork.MediaArtworkType.POSTER);
        this.addCheckImagesMovie(MediaArtwork.MediaArtworkType.BACKGROUND);
        this.scraperMetadataConfig.addAll(Arrays.asList(MovieScraperMetadataConfig.values()));
    }

    @Override
    protected ObjectWriter createObjectWriter() {
        return objectMapper.writerFor(MovieSettings.class);
    }

    public static synchronized MovieSettings getInstance() {
        return MovieSettings.getInstance(Globals.settings.getSettingsFolder());
    }

    public static synchronized MovieSettings getInstance(String folder) {
        if (instance == null) {
            instance = (MovieSettings)MovieSettings.getInstance(folder, CONFIG_FILE, MovieSettings.class);
        }
        return instance;
    }

    @Override
    public String getConfigFilename() {
        return CONFIG_FILE;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void writeDefaultSettings() {
        this.setMovieTableHiddenColumns(Arrays.asList("originalTitle", "sortTitle", "dateAdded", "filename", "path", "movieset", "fileSize", "audio", "video3d", "videoFormat", "votes", "edition", "mediaSource", "certification"));
        this.addDefaultEntries();
        String defaultLang = Locale.getDefault().getLanguage();
        CountryCode cc = CountryCode.getByCode(defaultLang.toUpperCase(Locale.ROOT));
        if (cc != null) {
            this.setCertificationCountry(cc);
        }
        for (MediaLanguages ml : MediaLanguages.values()) {
            if (!ml.name().equals(defaultLang)) continue;
            this.setScraperLanguage(ml);
        }
        this.saveSettings();
        Path mig = Paths.get("cache", "migv3movies.ds");
        if (mig.toFile().exists()) {
            try {
                List<String> datasources = Files.readAllLines(mig);
                for (String ds : datasources) {
                    this.addMovieDataSources(ds);
                }
                Files.delete(mig);
                this.saveSettings();
            }
            catch (IOException e) {
                LOGGER.warn("Could not migrate movie datasources! {}", (Throwable)e);
            }
        }
    }

    public void addMovieDataSources(String path) {
        if (!this.movieDataSources.contains(path)) {
            this.movieDataSources.add(path);
            this.firePropertyChange(MOVIE_DATA_SOURCE, null, this.movieDataSources);
            this.firePropertyChange("dataSource", null, this.movieDataSources);
        }
    }

    public void removeMovieDataSources(String path) {
        MovieList movieList = MovieList.getInstance();
        movieList.removeDatasource(path);
        this.movieDataSources.remove(path);
        this.firePropertyChange(MOVIE_DATA_SOURCE, null, this.movieDataSources);
        this.firePropertyChange("dataSource", null, this.movieDataSources);
    }

    public List<String> getMovieDataSource() {
        return this.movieDataSources;
    }

    public void addNfoFilename(MovieNfoNaming filename) {
        if (!this.nfoFilenames.contains((Object)filename)) {
            this.nfoFilenames.add(filename);
            this.firePropertyChange(NFO_FILENAME, null, this.nfoFilenames);
        }
    }

    public void clearNfoFilenames() {
        this.nfoFilenames.clear();
        this.firePropertyChange(NFO_FILENAME, null, this.nfoFilenames);
    }

    public List<MovieNfoNaming> getNfoFilenames() {
        return new ArrayList<MovieNfoNaming>(this.nfoFilenames);
    }

    public void addTrailerFilename(MovieTrailerNaming filename) {
        if (!this.trailerFilenames.contains(filename)) {
            this.trailerFilenames.add(filename);
            this.firePropertyChange(TRAILER_FILENAME, null, this.trailerFilenames);
        }
    }

    public void clearTrailerFilenames() {
        this.trailerFilenames.clear();
        this.firePropertyChange(TRAILER_FILENAME, null, this.trailerFilenames);
    }

    public List<MovieTrailerNaming> getTrailerFilenames() {
        return new ArrayList<MovieTrailerNaming>(this.trailerFilenames);
    }

    public void addPosterFilename(MoviePosterNaming filename) {
        if (!this.posterFilenames.contains(filename)) {
            this.posterFilenames.add(filename);
            this.firePropertyChange(POSTER_FILENAME, null, this.posterFilenames);
        }
    }

    public void clearPosterFilenames() {
        this.posterFilenames.clear();
        this.firePropertyChange(POSTER_FILENAME, null, this.posterFilenames);
    }

    public List<MoviePosterNaming> getPosterFilenames() {
        return new ArrayList<MoviePosterNaming>(this.posterFilenames);
    }

    public void addFanartFilename(MovieFanartNaming filename) {
        if (!this.fanartFilenames.contains(filename)) {
            this.fanartFilenames.add(filename);
            this.firePropertyChange(FANART_FILENAME, null, this.fanartFilenames);
        }
    }

    public void clearFanartFilenames() {
        this.fanartFilenames.clear();
        this.firePropertyChange(FANART_FILENAME, null, this.fanartFilenames);
    }

    public List<MovieFanartNaming> getFanartFilenames() {
        return new ArrayList<MovieFanartNaming>(this.fanartFilenames);
    }

    public void addBannerFilename(MovieBannerNaming filename) {
        if (!this.bannerFilenames.contains(filename)) {
            this.bannerFilenames.add(filename);
            this.firePropertyChange(BANNER_FILENAME, null, this.bannerFilenames);
        }
    }

    public void clearBannerFilenames() {
        this.bannerFilenames.clear();
        this.firePropertyChange(BANNER_FILENAME, null, this.bannerFilenames);
    }

    public List<MovieBannerNaming> getBannerFilenames() {
        return new ArrayList<MovieBannerNaming>(this.bannerFilenames);
    }

    public void addClearartFilename(MovieClearartNaming filename) {
        if (!this.clearartFilenames.contains(filename)) {
            this.clearartFilenames.add(filename);
            this.firePropertyChange(CLEARART_FILENAME, null, this.clearartFilenames);
        }
    }

    public void clearClearartFilenames() {
        this.clearartFilenames.clear();
        this.firePropertyChange(CLEARART_FILENAME, null, this.clearartFilenames);
    }

    public List<MovieClearartNaming> getClearartFilenames() {
        return new ArrayList<MovieClearartNaming>(this.clearartFilenames);
    }

    public void addThumbFilename(MovieThumbNaming filename) {
        if (!this.thumbFilenames.contains(filename)) {
            this.thumbFilenames.add(filename);
            this.firePropertyChange(THUMB_FILENAME, null, this.thumbFilenames);
        }
    }

    public void clearThumbFilenames() {
        this.thumbFilenames.clear();
        this.firePropertyChange(THUMB_FILENAME, null, this.thumbFilenames);
    }

    public List<MovieThumbNaming> getThumbFilenames() {
        return new ArrayList<MovieThumbNaming>(this.thumbFilenames);
    }

    public void addLogoFilename(MovieLogoNaming filename) {
        if (!this.logoFilenames.contains(filename)) {
            this.logoFilenames.add(filename);
            this.firePropertyChange(LOGO_FILENAME, null, this.logoFilenames);
        }
    }

    public void clearLogoFilenames() {
        this.logoFilenames.clear();
        this.firePropertyChange(LOGO_FILENAME, null, this.logoFilenames);
    }

    public List<MovieLogoNaming> getLogoFilenames() {
        return new ArrayList<MovieLogoNaming>(this.logoFilenames);
    }

    public void addClearlogoFilename(MovieClearlogoNaming filename) {
        if (!this.clearlogoFilenames.contains(filename)) {
            this.clearlogoFilenames.add(filename);
            this.firePropertyChange(CLEARLOGO_FILENAME, null, this.clearlogoFilenames);
        }
    }

    public void clearClearlogoFilenames() {
        this.clearlogoFilenames.clear();
        this.firePropertyChange(CLEARLOGO_FILENAME, null, this.clearlogoFilenames);
    }

    public List<MovieClearlogoNaming> getClearlogoFilenames() {
        return new ArrayList<MovieClearlogoNaming>(this.clearlogoFilenames);
    }

    public void addDiscartFilename(MovieDiscartNaming filename) {
        if (!this.discartFilenames.contains(filename)) {
            this.discartFilenames.add(filename);
            this.firePropertyChange(DISCART_FILENAME, null, this.discartFilenames);
        }
    }

    public void clearDiscartFilenames() {
        this.discartFilenames.clear();
        this.firePropertyChange(DISCART_FILENAME, null, this.discartFilenames);
    }

    public void clearCheckImagesMovie() {
        this.checkImagesMovie.clear();
        this.firePropertyChange(CHECK_IMAGES_MOVIE, null, this.checkImagesMovie);
    }

    public List<MediaArtwork.MediaArtworkType> getCheckImagesMovie() {
        return new ArrayList<MediaArtwork.MediaArtworkType>(this.checkImagesMovie);
    }

    public void addCheckImagesMovie(MediaArtwork.MediaArtworkType type) {
        if (!this.checkImagesMovie.contains((Object)type)) {
            this.checkImagesMovie.add(type);
            this.firePropertyChange(CHECK_IMAGES_MOVIE, null, this.checkImagesMovie);
        }
    }

    public List<MovieDiscartNaming> getDiscartFilenames() {
        return new ArrayList<MovieDiscartNaming>(this.discartFilenames);
    }

    public void addKeyartFilename(MovieKeyartNaming filename) {
        if (!this.keyartFilenames.contains(filename)) {
            this.keyartFilenames.add(filename);
            this.firePropertyChange(KEYART_FILENAME, null, this.keyartFilenames);
        }
    }

    public void clearKeyartFilenames() {
        this.keyartFilenames.clear();
        this.firePropertyChange(KEYART_FILENAME, null, this.keyartFilenames);
    }

    public List<MovieKeyartNaming> getKeyartFilenames() {
        return this.keyartFilenames;
    }

    public MediaArtwork.PosterSizes getImagePosterSize() {
        return this.imagePosterSize;
    }

    public void setImagePosterSize(MediaArtwork.PosterSizes newValue) {
        MediaArtwork.PosterSizes oldValue = this.imagePosterSize;
        this.imagePosterSize = newValue;
        this.firePropertyChange("imagePosterSize", (Object)oldValue, (Object)newValue);
    }

    public MediaArtwork.FanartSizes getImageFanartSize() {
        return this.imageFanartSize;
    }

    public void setImageFanartSize(MediaArtwork.FanartSizes newValue) {
        MediaArtwork.FanartSizes oldValue = this.imageFanartSize;
        this.imageFanartSize = newValue;
        this.firePropertyChange("imageFanartSize", (Object)oldValue, (Object)newValue);
    }

    public boolean isImageExtraThumbs() {
        return this.imageExtraThumbs;
    }

    public boolean isImageExtraThumbsResize() {
        return this.imageExtraThumbsResize;
    }

    public int getImageExtraThumbsSize() {
        return this.imageExtraThumbsSize;
    }

    public void setImageExtraThumbsResize(boolean newValue) {
        boolean oldValue = this.imageExtraThumbsResize;
        this.imageExtraThumbsResize = newValue;
        this.firePropertyChange("imageExtraThumbsResize", oldValue, newValue);
    }

    public void setImageExtraThumbsSize(int newValue) {
        int oldValue = this.imageExtraThumbsSize;
        this.imageExtraThumbsSize = newValue;
        this.firePropertyChange("imageExtraThumbsSize", oldValue, newValue);
    }

    public int getImageExtraThumbsCount() {
        return this.imageExtraThumbsCount;
    }

    public void setImageExtraThumbsCount(int newValue) {
        int oldValue = this.imageExtraThumbsCount;
        this.imageExtraThumbsCount = newValue;
        this.firePropertyChange("imageExtraThumbsCount", oldValue, newValue);
    }

    public int getImageExtraFanartCount() {
        return this.imageExtraFanartCount;
    }

    public void setImageExtraFanartCount(int newValue) {
        int oldValue = this.imageExtraFanartCount;
        this.imageExtraFanartCount = newValue;
        this.firePropertyChange("imageExtraFanartCount", oldValue, newValue);
    }

    public boolean isImageExtraFanart() {
        return this.imageExtraFanart;
    }

    public void setImageExtraThumbs(boolean newValue) {
        boolean oldValue = this.imageExtraThumbs;
        this.imageExtraThumbs = newValue;
        this.firePropertyChange("imageExtraThumbs", oldValue, newValue);
    }

    public void setImageExtraFanart(boolean newValue) {
        boolean oldValue = this.imageExtraFanart;
        this.imageExtraFanart = newValue;
        this.firePropertyChange("imageExtraFanart", oldValue, newValue);
    }

    public boolean isEnableMovieSetArtworkMovieFolder() {
        return this.enableMovieSetArtworkMovieFolder;
    }

    public void setEnableMovieSetArtworkMovieFolder(boolean newValue) {
        boolean oldValue = this.enableMovieSetArtworkMovieFolder;
        this.enableMovieSetArtworkMovieFolder = newValue;
        this.firePropertyChange("enableMovieSetArtworkMovieFolder", oldValue, newValue);
    }

    public boolean isEnableMovieSetArtworkFolder() {
        return this.enableMovieSetArtworkFolder;
    }

    public void setEnableMovieSetArtworkFolder(boolean newValue) {
        boolean oldValue = this.enableMovieSetArtworkFolder;
        this.enableMovieSetArtworkFolder = newValue;
        this.firePropertyChange("enableMovieSetArtworkFolder", oldValue, newValue);
    }

    public String getMovieSetArtworkFolder() {
        return this.movieSetArtworkFolder;
    }

    public void setMovieSetArtworkFolder(String newValue) {
        String oldValue = this.movieSetArtworkFolder;
        this.movieSetArtworkFolder = newValue;
        this.firePropertyChange("movieSetArtworkFolder", oldValue, newValue);
    }

    public boolean isMovieSetArtworkFolderStyleKodi() {
        return this.movieSetArtworkFolderStyleKodi;
    }

    public void setMovieSetArtworkFolderStyleKodi(boolean newValue) {
        boolean oldValue = this.movieSetArtworkFolderStyleKodi;
        this.movieSetArtworkFolderStyleKodi = newValue;
        this.firePropertyChange("movieSetArtworkFolderStyleKodi", oldValue, newValue);
    }

    public boolean isMovieSetArtworkFolderStyleAutomator() {
        return this.movieSetArtworkFolderStyleAutomator;
    }

    public void setMovieSetArtworkFolderStyleAutomator(boolean newValue) {
        boolean oldValue = this.movieSetArtworkFolderStyleAutomator;
        this.movieSetArtworkFolderStyleAutomator = newValue;
        this.firePropertyChange("movieSetArtworkFolderStyleAutomator", oldValue, newValue);
    }

    public MovieConnectors getMovieConnector() {
        return this.movieConnector;
    }

    public void setMovieConnector(MovieConnectors newValue) {
        MovieConnectors oldValue = this.movieConnector;
        this.movieConnector = newValue;
        this.firePropertyChange("movieConnector", (Object)oldValue, (Object)newValue);
    }

    public String getRenamerPathname() {
        return this.renamerPathname;
    }

    public void setRenamerPathname(String newValue) {
        String oldValue = this.renamerPathname;
        this.renamerPathname = newValue;
        this.firePropertyChange("renamerPathname", oldValue, newValue);
    }

    public String getRenamerFilename() {
        return this.renamerFilename;
    }

    public void setRenamerFilename(String newValue) {
        String oldValue = this.renamerFilename;
        this.renamerFilename = newValue;
        this.firePropertyChange("renamerFilename", oldValue, newValue);
    }

    public boolean isRenamerPathnameSpaceSubstitution() {
        return this.renamerPathnameSpaceSubstitution;
    }

    public void setRenamerPathnameSpaceSubstitution(boolean newValue) {
        boolean oldValue = this.renamerPathnameSpaceSubstitution;
        this.renamerPathnameSpaceSubstitution = newValue;
        this.firePropertyChange("renamerPathnameSpaceSubstitution", oldValue, newValue);
    }

    public boolean isRenamerFilenameSpaceSubstitution() {
        return this.renamerFilenameSpaceSubstitution;
    }

    @JsonProperty(value="renamerSpaceSubstitution")
    public void setRenamerFilenameSpaceSubstitution(boolean newValue) {
        boolean oldValue = this.renamerFilenameSpaceSubstitution;
        this.renamerFilenameSpaceSubstitution = newValue;
        this.firePropertyChange("renamerFilenameSpaceSubstitution", oldValue, newValue);
    }

    public void setRenameAfterScrape(boolean newValue) {
        boolean oldValue = this.renameAfterScrape;
        this.renameAfterScrape = newValue;
        this.firePropertyChange("renameAfterScrape", oldValue, newValue);
    }

    public boolean isRenameAfterScrape() {
        return this.renameAfterScrape;
    }

    public String getRenamerPathnameSpaceReplacement() {
        return this.renamerPathnameSpaceReplacement;
    }

    public void setRenamerPathnameSpaceReplacement(String newValue) {
        String oldValue = this.renamerPathnameSpaceReplacement;
        this.renamerPathnameSpaceReplacement = newValue;
        this.firePropertyChange("renamerPathnameSpaceReplacement", oldValue, newValue);
    }

    @JsonProperty(value="renamerSpaceReplacement")
    public String getRenamerFilenameSpaceReplacement() {
        return this.renamerFilenameSpaceReplacement;
    }

    public void setRenamerFilenameSpaceReplacement(String newValue) {
        String oldValue = this.renamerFilenameSpaceReplacement;
        this.renamerFilenameSpaceReplacement = newValue;
        this.firePropertyChange("renamerFilenameSpaceReplacement", oldValue, newValue);
    }

    public String getRenamerColonReplacement() {
        return this.renamerColonReplacement;
    }

    public void setRenamerColonReplacement(String newValue) {
        String oldValue = this.renamerColonReplacement;
        this.renamerColonReplacement = newValue;
        this.firePropertyChange("renamerColonReplacement", oldValue, newValue);
    }

    public String getMovieScraper() {
        if (StringUtils.isBlank((CharSequence)this.movieScraper)) {
            return "tmdb";
        }
        return this.movieScraper;
    }

    public void setMovieScraper(String newValue) {
        String oldValue = this.movieScraper;
        this.movieScraper = newValue;
        this.firePropertyChange("movieScraper", oldValue, newValue);
    }

    public void addMovieArtworkScraper(String newValue) {
        if (!this.artworkScrapers.contains(newValue)) {
            this.artworkScrapers.add(newValue);
            this.firePropertyChange(ARTWORK_SCRAPERS, null, this.artworkScrapers);
        }
    }

    public void removeMovieArtworkScraper(String newValue) {
        if (this.artworkScrapers.contains(newValue)) {
            this.artworkScrapers.remove(newValue);
            this.firePropertyChange(ARTWORK_SCRAPERS, null, this.artworkScrapers);
        }
    }

    public List<String> getArtworkScrapers() {
        return this.artworkScrapers;
    }

    public boolean isScrapeBestImage() {
        return this.scrapeBestImage;
    }

    public void setScrapeBestImage(boolean newValue) {
        boolean oldValue = this.scrapeBestImage;
        this.scrapeBestImage = newValue;
        this.firePropertyChange("scrapeBestImage", oldValue, newValue);
    }

    public void addMovieTrailerScraper(String newValue) {
        if (!this.trailerScrapers.contains(newValue)) {
            this.trailerScrapers.add(newValue);
            this.firePropertyChange(TRAILER_SCRAPERS, null, this.trailerScrapers);
        }
    }

    public void removeMovieTrailerScraper(String newValue) {
        if (this.trailerScrapers.contains(newValue)) {
            this.trailerScrapers.remove(newValue);
            this.firePropertyChange(TRAILER_SCRAPERS, null, this.trailerScrapers);
        }
    }

    public List<String> getTrailerScrapers() {
        return this.trailerScrapers;
    }

    public void addMovieSubtitleScraper(String newValue) {
        if (!this.subtitleScrapers.contains(newValue)) {
            this.subtitleScrapers.add(newValue);
            this.firePropertyChange(SUBTITLE_SCRAPERS, null, this.subtitleScrapers);
        }
    }

    public void removeMovieSubtitleScraper(String newValue) {
        if (this.subtitleScrapers.contains(newValue)) {
            this.subtitleScrapers.remove(newValue);
            this.firePropertyChange(SUBTITLE_SCRAPERS, null, this.subtitleScrapers);
        }
    }

    public List<String> getSubtitleScrapers() {
        return this.subtitleScrapers;
    }

    public void addSkipFolder(String newValue) {
        if (!this.skipFolders.contains(newValue)) {
            this.skipFolders.add(newValue);
            this.firePropertyChange(SKIP_FOLDER, null, this.skipFolders);
        }
    }

    public void removeSkipFolder(String newValue) {
        if (this.skipFolders.contains(newValue)) {
            this.skipFolders.remove(newValue);
            this.firePropertyChange(SKIP_FOLDER, null, this.skipFolders);
        }
    }

    public List<String> getSkipFolder() {
        return this.skipFolders;
    }

    public void setMovieTableHiddenColumns(List<String> hiddenColumns) {
        this.movieTableHiddenColumns.clear();
        this.movieTableHiddenColumns.addAll(hiddenColumns);
        this.firePropertyChange("movieTableHiddenColumns", null, this.movieTableHiddenColumns);
    }

    public List<String> getMovieTableHiddenColumns() {
        return this.movieTableHiddenColumns;
    }

    public void setMovieSetTableHiddenColumns(List<String> hiddenColumns) {
        this.movieSetTableHiddenColumns.clear();
        this.movieSetTableHiddenColumns.addAll(hiddenColumns);
        this.firePropertyChange("movieSetTableHiddenColumns", null, this.movieSetTableHiddenColumns);
    }

    public List<String> getMovieSetTableHiddenColumns() {
        return this.movieSetTableHiddenColumns;
    }

    public void setUiFilters(List<AbstractSettings.UIFilters> filters) {
        this.uiFilters.clear();
        this.uiFilters.addAll(filters);
        this.firePropertyChange(UI_FILTERS, null, this.uiFilters);
    }

    public List<AbstractSettings.UIFilters> getUiFilters() {
        if (this.storeUiFilters) {
            return this.uiFilters;
        }
        return new ArrayList<AbstractSettings.UIFilters>();
    }

    public void setMovieSetUiFilters(List<AbstractSettings.UIFilters> filters) {
        this.movieSetUiFilters.clear();
        this.movieSetUiFilters.addAll(filters);
        this.firePropertyChange(MOVIE_SET_UI_FILTERS, null, this.movieSetUiFilters);
    }

    public List<AbstractSettings.UIFilters> getMovieSetUiFilters() {
        if (this.storeUiFilters) {
            return this.movieSetUiFilters;
        }
        return new ArrayList<AbstractSettings.UIFilters>();
    }

    public void setStoreUiFilters(boolean newValue) {
        boolean oldValue = this.storeUiFilters;
        this.storeUiFilters = newValue;
        this.firePropertyChange("storeUiFilters", oldValue, newValue);
    }

    public boolean isStoreUiFilters() {
        return this.storeUiFilters;
    }

    public boolean isWriteActorImages() {
        return this.writeActorImages;
    }

    public void setWriteActorImages(boolean newValue) {
        boolean oldValue = this.writeActorImages;
        this.writeActorImages = newValue;
        this.firePropertyChange("writeActorImages", oldValue, newValue);
    }

    public MediaLanguages getScraperLanguage() {
        return this.scraperLanguage;
    }

    public void setScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.scraperLanguage;
        this.scraperLanguage = newValue;
        this.firePropertyChange("scraperLanguage", (Object)oldValue, (Object)newValue);
    }

    public MediaLanguages getSubtitleScraperLanguage() {
        return this.subtitleScraperLanguage;
    }

    public void setSubtitleScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.subtitleScraperLanguage;
        this.subtitleScraperLanguage = newValue;
        this.firePropertyChange("subtitleScraperLanguage", (Object)oldValue, (Object)newValue);
    }

    public CountryCode getCertificationCountry() {
        return this.certificationCountry;
    }

    public void setCertificationCountry(CountryCode newValue) {
        CountryCode oldValue = this.certificationCountry;
        this.certificationCountry = newValue;
        this.firePropertyChange("certificationCountry", (Object)oldValue, (Object)newValue);
    }

    public double getScraperThreshold() {
        return this.scraperThreshold;
    }

    public void setScraperThreshold(double newValue) {
        double oldValue = this.scraperThreshold;
        this.scraperThreshold = newValue;
        this.firePropertyChange("scraperThreshold", oldValue, newValue);
    }

    public boolean isRenamerNfoCleanup() {
        return this.renamerNfoCleanup;
    }

    public void setRenamerNfoCleanup(boolean newValue) {
        boolean oldValue = this.renamerNfoCleanup;
        this.renamerNfoCleanup = newValue;
        this.firePropertyChange("renamerNfoCleanup", oldValue, newValue);
    }

    public boolean isBuildImageCacheOnImport() {
        return this.buildImageCacheOnImport;
    }

    public void setBuildImageCacheOnImport(boolean newValue) {
        boolean oldValue = this.buildImageCacheOnImport;
        this.buildImageCacheOnImport = newValue;
        this.firePropertyChange("buildImageCacheOnImport", oldValue, newValue);
    }

    public boolean isRenamerCreateMoviesetForSingleMovie() {
        return this.renamerCreateMoviesetForSingleMovie;
    }

    public void setRenamerCreateMoviesetForSingleMovie(boolean newValue) {
        boolean oldValue = this.renamerCreateMoviesetForSingleMovie;
        this.renamerCreateMoviesetForSingleMovie = newValue;
        this.firePropertyChange("renamerCreateMoviesetForSingleMovie", oldValue, newValue);
    }

    public boolean isRuntimeFromMediaInfo() {
        return this.runtimeFromMediaInfo;
    }

    public void setRuntimeFromMediaInfo(boolean newValue) {
        boolean oldValue = this.runtimeFromMediaInfo;
        this.runtimeFromMediaInfo = newValue;
        this.firePropertyChange("runtimeFromMediaInfo", oldValue, newValue);
    }

    public boolean isExtractArtworkFromVsmeta() {
        return this.extractArtworkFromVsmeta;
    }

    public void setExtractArtworkFromVsmeta(boolean newValue) {
        boolean oldValue = this.extractArtworkFromVsmeta;
        this.extractArtworkFromVsmeta = newValue;
        this.firePropertyChange("extractArtworkFromVsmeta", oldValue, newValue);
    }

    public boolean isIncludeExternalAudioStreams() {
        return this.includeExternalAudioStreams;
    }

    public void setIncludeExternalAudioStreams(boolean newValue) {
        boolean oldValue = this.includeExternalAudioStreams;
        this.includeExternalAudioStreams = newValue;
        this.firePropertyChange("includeExternalAudioStreams", oldValue, newValue);
    }

    public boolean isAsciiReplacement() {
        return this.asciiReplacement;
    }

    public void setAsciiReplacement(boolean newValue) {
        boolean oldValue = this.asciiReplacement;
        this.asciiReplacement = newValue;
        this.firePropertyChange("asciiReplacement", oldValue, newValue);
    }

    public void addBadWord(String badWord) {
        if (!this.badWords.contains(badWord.toLowerCase(Locale.ROOT))) {
            this.badWords.add(badWord.toLowerCase(Locale.ROOT));
            this.firePropertyChange(BAD_WORD, null, this.badWords);
        }
    }

    public void removeBadWord(String badWord) {
        this.badWords.remove(badWord.toLowerCase(Locale.ROOT));
        this.firePropertyChange(BAD_WORD, null, this.badWords);
    }

    public List<String> getBadWord() {
        ListIterator<String> iterator = this.badWords.listIterator();
        while (iterator.hasNext()) {
            iterator.set(iterator.next().toLowerCase(Locale.ROOT));
        }
        return this.badWords;
    }

    public boolean isScraperFallback() {
        return this.scraperFallback;
    }

    public void setScraperFallback(boolean newValue) {
        boolean oldValue = this.scraperFallback;
        this.scraperFallback = newValue;
        this.firePropertyChange("scraperFallback", oldValue, newValue);
    }

    public boolean isUseTrailerPreference() {
        return this.useTrailerPreference;
    }

    public void setUseTrailerPreference(boolean newValue) {
        boolean oldValue = this.useTrailerPreference;
        this.useTrailerPreference = newValue;
        this.firePropertyChange("useTrailerPreference", oldValue, newValue);
        this.firePropertyChange("automaticTrailerDownload", oldValue, newValue);
    }

    public boolean isAutomaticTrailerDownload() {
        return this.useTrailerPreference && this.automaticTrailerDownload;
    }

    public void setAutomaticTrailerDownload(boolean newValue) {
        boolean oldValue = this.automaticTrailerDownload;
        this.automaticTrailerDownload = newValue;
        this.firePropertyChange("automaticTrailerDownload", oldValue, newValue);
    }

    public TrailerQuality getTrailerQuality() {
        return this.trailerQuality;
    }

    public void setTrailerQuality(TrailerQuality newValue) {
        TrailerQuality oldValue = this.trailerQuality;
        this.trailerQuality = newValue;
        this.firePropertyChange("trailerQuality", (Object)oldValue, (Object)newValue);
    }

    public TrailerSources getTrailerSource() {
        return this.trailerSource;
    }

    public void setTrailerSource(TrailerSources newValue) {
        TrailerSources oldValue = this.trailerSource;
        this.trailerSource = newValue;
        this.firePropertyChange("trailerSource", (Object)oldValue, (Object)newValue);
    }

    public void setSyncTrakt(boolean newValue) {
        boolean oldValue = this.syncTrakt;
        this.syncTrakt = newValue;
        this.firePropertyChange("syncTrakt", oldValue, newValue);
    }

    public boolean getSyncTrakt() {
        return this.syncTrakt;
    }

    public boolean getPreferPersonalRating() {
        return this.preferPersonalRating;
    }

    public void setPreferPersonalRating(boolean newValue) {
        boolean oldValue = this.preferPersonalRating;
        this.preferPersonalRating = newValue;
        this.firePropertyChange("preferPersonalRating", oldValue, newValue);
    }

    public String getPreferredRating() {
        return this.preferredRating;
    }

    public void setPreferredRating(String newValue) {
        String oldValue = this.preferredRating;
        this.preferredRating = newValue;
        this.firePropertyChange("preferredRating", oldValue, newValue);
    }

    public MediaLanguages getImageScraperLanguage() {
        return this.imageScraperLanguage;
    }

    public void setImageScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.imageScraperLanguage;
        this.imageScraperLanguage = newValue;
        this.firePropertyChange("imageScraperLanguage", (Object)oldValue, (Object)newValue);
    }

    public boolean isImageLanguagePriority() {
        return this.imageLanguagePriority;
    }

    public void setImageLanguagePriority(boolean newValue) {
        boolean oldValue = this.imageLanguagePriority;
        this.imageLanguagePriority = newValue;
        this.firePropertyChange("imageLanguagePriority", oldValue, newValue);
    }

    public CertificationStyle getCertificationStyle() {
        return this.certificationStyle;
    }

    public void setCertificationStyle(CertificationStyle newValue) {
        CertificationStyle oldValue = this.certificationStyle;
        this.certificationStyle = newValue;
        this.firePropertyChange("certificationStyle", (Object)oldValue, (Object)newValue);
    }

    public LanguageStyle getSubtitleLanguageStyle() {
        return this.subtitleLanguageStyle;
    }

    public void setSubtitleLanguageStyle(LanguageStyle newValue) {
        LanguageStyle oldValue = this.subtitleLanguageStyle;
        this.subtitleLanguageStyle = newValue;
        this.firePropertyChange("subtitleLanguageStyle", (Object)oldValue, (Object)newValue);
    }

    public boolean isSubtitleWithoutLanguageTag() {
        return this.subtitleWithoutLanguageTag;
    }

    public void setSubtitleWithoutLanguageTag(boolean newValue) {
        boolean oldValue = this.subtitleWithoutLanguageTag;
        this.subtitleWithoutLanguageTag = newValue;
        this.firePropertyChange("subtitleWithoutLanguageTag", oldValue, newValue);
    }

    public List<MovieScraperMetadataConfig> getScraperMetadataConfig() {
        return this.scraperMetadataConfig;
    }

    public void setScraperMetadataConfig(List<MovieScraperMetadataConfig> newValues) {
        this.scraperMetadataConfig.clear();
        this.scraperMetadataConfig.addAll(newValues);
        this.firePropertyChange("scraperMetadataConfig", null, this.scraperMetadataConfig);
    }

    public boolean isWriteCleanNfo() {
        return this.writeCleanNfo;
    }

    public void setWriteCleanNfo(boolean newValue) {
        boolean oldValue = this.writeCleanNfo;
        this.writeCleanNfo = newValue;
        this.firePropertyChange("writeCleanNfo", oldValue, newValue);
    }

    public DateField getNfoDateAddedField() {
        return this.nfoDateAddedField;
    }

    public void setNfoDateAddedField(DateField newValue) {
        DateField oldValue = this.nfoDateAddedField;
        this.nfoDateAddedField = newValue;
        this.firePropertyChange("nfoDateAddedField", (Object)oldValue, (Object)newValue);
    }

    public MediaLanguages getNfoLanguage() {
        return this.nfoLanguage;
    }

    public void setNfoLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.nfoLanguage;
        this.nfoLanguage = newValue;
        this.firePropertyChange("nfoLanguage", (Object)oldValue, (Object)newValue);
    }

    public boolean isCreateOutline() {
        return this.createOutline;
    }

    public void setCreateOutline(boolean newValue) {
        boolean oldValue = this.createOutline;
        this.createOutline = newValue;
        this.firePropertyChange("createOutline", oldValue, newValue);
    }

    public boolean isOutlineFirstSentence() {
        return this.outlineFirstSentence;
    }

    public void setOutlineFirstSentence(boolean newValue) {
        boolean oldValue = this.outlineFirstSentence;
        this.outlineFirstSentence = newValue;
        this.firePropertyChange("outlineFirstSentence", oldValue, newValue);
    }

    public boolean getCapitalWordsInTitles() {
        return this.capitalWordsInTitles;
    }

    public void setCapitalWordsInTitles(boolean newValue) {
        boolean oldValue = this.capitalWordsInTitles;
        this.capitalWordsInTitles = newValue;
        this.firePropertyChange("capitalWordsInTitles", oldValue, newValue);
    }

    public boolean isShowLogosPanel() {
        return this.showLogosPanel;
    }

    public void setShowLogosPanel(boolean newValue) {
        boolean oldValue = this.showLogosPanel;
        this.showLogosPanel = newValue;
        this.firePropertyChange("showLogosPanel", oldValue, newValue);
    }

    public void setDefaultSettingsForXbmc() {
        this.nfoFilenames.clear();
        this.addNfoFilename(MovieNfoNaming.FILENAME_NFO);
        this.posterFilenames.clear();
        this.addPosterFilename(MoviePosterNaming.FILENAME_POSTER);
        this.fanartFilenames.clear();
        this.addFanartFilename(MovieFanartNaming.FILENAME_FANART);
        this.bannerFilenames.clear();
        this.addBannerFilename(MovieBannerNaming.FILENAME_BANNER);
        this.clearartFilenames.clear();
        this.addClearartFilename(MovieClearartNaming.FILENAME_CLEARART);
        this.thumbFilenames.clear();
        this.addThumbFilename(MovieThumbNaming.FILENAME_LANDSCAPE);
        this.logoFilenames.clear();
        this.addLogoFilename(MovieLogoNaming.FILENAME_LOGO);
        this.clearlogoFilenames.clear();
        this.addClearlogoFilename(MovieClearlogoNaming.FILENAME_CLEARLOGO);
        this.discartFilenames.clear();
        this.addDiscartFilename(MovieDiscartNaming.FILENAME_DISC);
        this.keyartFilenames.clear();
        this.addKeyartFilename(MovieKeyartNaming.FILENAME_KEYART);
        this.trailerFilenames.clear();
        this.addTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        this.setMovieConnector(MovieConnectors.XBMC);
        this.setRenamerPathname(DEFAULT_RENAMER_FOLDER_PATTERN);
        this.setRenamerFilename(DEFAULT_RENAMER_FILE_PATTERN);
        this.setCertificationStyle(CertificationStyle.LARGE);
        this.firePropertyChange("preset", false, true);
    }

    public void setDefaultSettingsForKodi() {
        this.nfoFilenames.clear();
        this.addNfoFilename(MovieNfoNaming.FILENAME_NFO);
        this.posterFilenames.clear();
        this.addPosterFilename(MoviePosterNaming.FILENAME_POSTER);
        this.fanartFilenames.clear();
        this.addFanartFilename(MovieFanartNaming.FILENAME_FANART);
        this.bannerFilenames.clear();
        this.addBannerFilename(MovieBannerNaming.FILENAME_BANNER);
        this.clearartFilenames.clear();
        this.addClearartFilename(MovieClearartNaming.FILENAME_CLEARART);
        this.thumbFilenames.clear();
        this.addThumbFilename(MovieThumbNaming.FILENAME_LANDSCAPE);
        this.logoFilenames.clear();
        this.addLogoFilename(MovieLogoNaming.FILENAME_LOGO);
        this.clearlogoFilenames.clear();
        this.addClearlogoFilename(MovieClearlogoNaming.FILENAME_CLEARLOGO);
        this.discartFilenames.clear();
        this.addDiscartFilename(MovieDiscartNaming.FILENAME_DISCART);
        this.keyartFilenames.clear();
        this.addKeyartFilename(MovieKeyartNaming.FILENAME_KEYART);
        this.trailerFilenames.clear();
        this.addTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        this.setMovieConnector(MovieConnectors.KODI);
        this.setRenamerPathname(DEFAULT_RENAMER_FOLDER_PATTERN);
        this.setRenamerFilename(DEFAULT_RENAMER_FILE_PATTERN);
        this.setCertificationStyle(CertificationStyle.LARGE);
        this.firePropertyChange("preset", false, true);
    }

    public void setDefaultSettingsForMediaPortal1() {
        this.nfoFilenames.clear();
        this.addNfoFilename(MovieNfoNaming.FILENAME_NFO);
        this.posterFilenames.clear();
        this.addPosterFilename(MoviePosterNaming.POSTER);
        this.fanartFilenames.clear();
        this.addFanartFilename(MovieFanartNaming.FANART);
        this.bannerFilenames.clear();
        this.addBannerFilename(MovieBannerNaming.BANNER);
        this.clearartFilenames.clear();
        this.addClearartFilename(MovieClearartNaming.CLEARART);
        this.thumbFilenames.clear();
        this.addThumbFilename(MovieThumbNaming.THUMB);
        this.logoFilenames.clear();
        this.addLogoFilename(MovieLogoNaming.LOGO);
        this.clearlogoFilenames.clear();
        this.addClearlogoFilename(MovieClearlogoNaming.CLEARLOGO);
        this.discartFilenames.clear();
        this.addDiscartFilename(MovieDiscartNaming.DISC);
        this.keyartFilenames.clear();
        this.addKeyartFilename(MovieKeyartNaming.KEYART);
        this.trailerFilenames.clear();
        this.addTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        this.setMovieConnector(MovieConnectors.MP);
        this.setRenamerPathname(DEFAULT_RENAMER_FOLDER_PATTERN);
        this.setRenamerFilename(DEFAULT_RENAMER_FILE_PATTERN);
        this.setCertificationStyle(CertificationStyle.TECHNICAL);
        this.firePropertyChange("preset", false, true);
    }

    public void setDefaultSettingsForMediaPortal2() {
        this.nfoFilenames.clear();
        this.addNfoFilename(MovieNfoNaming.FILENAME_NFO);
        this.posterFilenames.clear();
        this.addPosterFilename(MoviePosterNaming.POSTER);
        this.fanartFilenames.clear();
        this.addFanartFilename(MovieFanartNaming.FANART);
        this.bannerFilenames.clear();
        this.addBannerFilename(MovieBannerNaming.BANNER);
        this.clearartFilenames.clear();
        this.addClearartFilename(MovieClearartNaming.CLEARART);
        this.thumbFilenames.clear();
        this.addThumbFilename(MovieThumbNaming.THUMB);
        this.logoFilenames.clear();
        this.addLogoFilename(MovieLogoNaming.LOGO);
        this.clearlogoFilenames.clear();
        this.addClearlogoFilename(MovieClearlogoNaming.CLEARLOGO);
        this.discartFilenames.clear();
        this.addDiscartFilename(MovieDiscartNaming.DISC);
        this.keyartFilenames.clear();
        this.addKeyartFilename(MovieKeyartNaming.KEYART);
        this.trailerFilenames.clear();
        this.addTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        this.setMovieConnector(MovieConnectors.KODI);
        this.setRenamerPathname(DEFAULT_RENAMER_FOLDER_PATTERN);
        this.setRenamerFilename(DEFAULT_RENAMER_FILE_PATTERN);
        this.setCertificationStyle(CertificationStyle.TECHNICAL);
        this.firePropertyChange("preset", false, true);
    }

    public void setDefaultSettingsForPlex() {
        this.nfoFilenames.clear();
        this.addNfoFilename(MovieNfoNaming.FILENAME_NFO);
        this.posterFilenames.clear();
        this.addPosterFilename(MoviePosterNaming.POSTER);
        this.fanartFilenames.clear();
        this.addFanartFilename(MovieFanartNaming.FANART);
        this.bannerFilenames.clear();
        this.addBannerFilename(MovieBannerNaming.BANNER);
        this.clearartFilenames.clear();
        this.addClearartFilename(MovieClearartNaming.CLEARART);
        this.thumbFilenames.clear();
        this.addThumbFilename(MovieThumbNaming.THUMB);
        this.logoFilenames.clear();
        this.addLogoFilename(MovieLogoNaming.LOGO);
        this.clearlogoFilenames.clear();
        this.addClearlogoFilename(MovieClearlogoNaming.CLEARLOGO);
        this.discartFilenames.clear();
        this.addDiscartFilename(MovieDiscartNaming.DISC);
        this.keyartFilenames.clear();
        this.addKeyartFilename(MovieKeyartNaming.KEYART);
        this.trailerFilenames.clear();
        this.addTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        this.setMovieConnector(MovieConnectors.XBMC);
        this.setRenamerPathname(DEFAULT_RENAMER_FOLDER_PATTERN);
        this.setRenamerFilename(DEFAULT_RENAMER_FILE_PATTERN);
        this.setCertificationStyle(CertificationStyle.SHORT);
        this.firePropertyChange("preset", false, true);
    }

    public void setDefaultScrapers() {
        this.artworkScrapers.clear();
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.MOVIE_ARTWORK)) {
            this.addMovieArtworkScraper(ms.getId());
        }
        this.trailerScrapers.clear();
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.MOVIE_TRAILER)) {
            this.addMovieTrailerScraper(ms.getId());
        }
        this.subtitleScrapers.clear();
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.SUBTITLE)) {
            this.addMovieSubtitleScraper(ms.getId());
        }
    }
}

