/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.UTF8Control;

public enum MovieSetScraperMetadataConfig implements ScraperMetadataConfig
{
    TITLE(ScraperMetadataConfig.Type.METADATA),
    PLOT(ScraperMetadataConfig.Type.METADATA),
    POSTER(ScraperMetadataConfig.Type.ARTWORK),
    FANART(ScraperMetadataConfig.Type.ARTWORK),
    BANNER(ScraperMetadataConfig.Type.ARTWORK),
    CLEARART(ScraperMetadataConfig.Type.ARTWORK),
    THUMB(ScraperMetadataConfig.Type.ARTWORK),
    LOGO(ScraperMetadataConfig.Type.ARTWORK),
    CLEARLOGO(ScraperMetadataConfig.Type.ARTWORK),
    DISCART(ScraperMetadataConfig.Type.ARTWORK, "mediafiletype.disc"),
    KEYART(ScraperMetadataConfig.Type.ARTWORK);

    private static final ResourceBundle BUNDLE;
    private ScraperMetadataConfig.Type type;
    private String description;
    private String tooltip;

    private MovieSetScraperMetadataConfig(ScraperMetadataConfig.Type type) {
        this(type, null, null);
    }

    private MovieSetScraperMetadataConfig(ScraperMetadataConfig.Type type, String description) {
        this(type, description, null);
    }

    private MovieSetScraperMetadataConfig(ScraperMetadataConfig.Type type, String description, String tooltip) {
        this.type = type;
        this.description = description;
        this.tooltip = tooltip;
    }

    @Override
    public ScraperMetadataConfig.Type getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        if (StringUtils.isBlank((CharSequence)this.description)) {
            try {
                if (this.type == ScraperMetadataConfig.Type.ARTWORK) {
                    return BUNDLE.getString("mediafiletype." + this.name().toLowerCase(Locale.ROOT));
                }
                return BUNDLE.getString("metatag." + this.name().toLowerCase(Locale.ROOT));
            }
            catch (Exception exception) {}
        } else {
            try {
                return BUNDLE.getString(this.description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getToolTip() {
        if (StringUtils.isBlank((CharSequence)this.tooltip)) {
            return null;
        }
        try {
            return BUNDLE.getString(this.tooltip);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    }
}

