/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import com.floreysoft.jmte.Renderer;
import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.token.Token;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IFileNaming;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.core.jmte.NamedArrayRenderer;
import org.tinymediamanager.core.jmte.NamedDateRenderer;
import org.tinymediamanager.core.jmte.NamedFilesizeRenderer;
import org.tinymediamanager.core.jmte.NamedLowerCaseRenderer;
import org.tinymediamanager.core.jmte.NamedTitleCaseRenderer;
import org.tinymediamanager.core.jmte.NamedUpperCaseRenderer;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.jmte.ZeroNumberRenderer;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.filenaming.MovieBannerNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearlogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieDiscartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieKeyartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieLogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.core.movie.filenaming.MoviePosterNaming;
import org.tinymediamanager.core.movie.filenaming.MovieThumbNaming;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MovieRenamer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieRenamer.class);
    private static final List<String> KNOWN_IMAGE_FILE_EXTENSIONS = Arrays.asList("jpg", "jpeg", "png", "bmp", "tbn", "gif");
    private static final Pattern ALPHANUM = Pattern.compile(".*?([a-zA-Z0-9]{1}).*$");
    private static final Pattern TITLE_PATTERN = Pattern.compile("\\$\\{.*?title.*?\\}", 2);
    private static final Pattern YEAR_ID_PATTERN = Pattern.compile("\\$\\{.*?(year|imdb|tmdb).*?\\}", 2);
    public static final Map<String, String> TOKEN_MAP = MovieRenamer.createTokenMap();

    private MovieRenamer() {
    }

    private static Map<String, String> createTokenMap() {
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        tokenMap.put("title", "movie.title");
        tokenMap.put("originalTitle", "movie.originalTitle");
        tokenMap.put("sorttitle", "movie.sortTitle");
        tokenMap.put("year", "movie.year");
        tokenMap.put("releaseDate", "movie.releaseDate;date(yyyy-MM-dd)");
        tokenMap.put("titleSortable", "movie.titleSortable");
        tokenMap.put("rating", "movie.rating.rating");
        tokenMap.put("imdb", "movie.imdbId");
        tokenMap.put("certification", "movie.certification");
        tokenMap.put("language", "movie.spokenLanguages");
        tokenMap.put("genres", "movie.genres");
        tokenMap.put("genresAsString", "movie.genresAsString");
        tokenMap.put("tags", "movie.tags");
        tokenMap.put("actors", "movie.actors");
        tokenMap.put("producers", "movie.producers");
        tokenMap.put("directors", "movie.directors");
        tokenMap.put("writers", "movie.writers");
        tokenMap.put("videoCodec", "movie.mediaInfoVideoCodec");
        tokenMap.put("videoFormat", "movie.mediaInfoVideoFormat");
        tokenMap.put("videoResolution", "movie.mediaInfoVideoResolution");
        tokenMap.put("videoBitDepth", "movie.mediaInfoVideoBitDepth");
        tokenMap.put("audioCodec", "movie.mediaInfoAudioCodec");
        tokenMap.put("audioCodecList", "movie.mediaInfoAudioCodecList");
        tokenMap.put("audioCodecsAsString", "movie.mediaInfoAudioCodecList;array");
        tokenMap.put("audioChannels", "movie.mediaInfoAudioChannels");
        tokenMap.put("audioChannelList", "movie.mediaInfoAudioChannelList");
        tokenMap.put("audioChannelsAsString", "movie.mediaInfoAudioChannelList;array");
        tokenMap.put("audioLanguage", "movie.mediaInfoAudioLanguage");
        tokenMap.put("audioLanguageList", "movie.mediaInfoAudioLanguageList");
        tokenMap.put("audioLanguagesAsString", "movie.mediaInfoAudioLanguageList;array");
        tokenMap.put("subtitleLanguageList", "movie.mediaInfoSubtitleLanguageList");
        tokenMap.put("subtitleLanguagesAsString", "movie.mediaInfoSubtitleLanguageList;array");
        tokenMap.put("3Dformat", "movie.video3DFormat");
        tokenMap.put("hdr", "movie.videoHDRFormat");
        tokenMap.put("filesize", "movie.videoFilesize;filesize");
        tokenMap.put("mediaSource", "movie.mediaSource");
        tokenMap.put("edition", "movie.edition");
        tokenMap.put("parent", "movie.parent");
        tokenMap.put("note", "movie.note");
        return tokenMap;
    }

    static String morphTemplate(String template) {
        Matcher matcher;
        Pattern pattern;
        String morphedTemplate = template;
        for (Map.Entry<String, String> entry : TOKEN_MAP.entrySet()) {
            pattern = Pattern.compile("\\$\\{" + entry.getKey() + "([^a-zA-Z0-9])", 2);
            matcher = pattern.matcher(morphedTemplate);
            while (matcher.find()) {
                morphedTemplate = morphedTemplate.replace(matcher.group(), "${" + entry.getValue() + matcher.group(1));
            }
        }
        for (Map.Entry<String, String> entry : TOKEN_MAP.entrySet()) {
            pattern = Pattern.compile("\\$\\{(.*?)," + entry.getKey() + "([^a-zA-Z0-9])", 2);
            matcher = pattern.matcher(morphedTemplate);
            while (matcher.find()) {
                morphedTemplate = morphedTemplate.replace(matcher.group(), "${" + matcher.group(1) + "," + entry.getValue() + matcher.group(2));
            }
        }
        morphedTemplate = morphedTemplate.replace("\\", "\\\\");
        return morphedTemplate;
    }

    private static void renameSubtitles(Movie m) {
        Set<String> langArray = LanguageUtils.KEY_TO_LOCALE_MAP.keySet();
        List<MediaFile> subtitleFiles = m.getMediaFiles(MediaFileType.SUBTITLE);
        for (MediaFile sub : subtitleFiles) {
            String forced;
            String lang;
            String originalLang;
            block21: {
                Object mfs;
                block20: {
                    originalLang = "";
                    lang = "";
                    forced = "";
                    List<MediaFileSubtitle> mfsl = sub.getSubtitles();
                    if (mfsl == null || mfsl.isEmpty()) break block20;
                    mfs = mfsl.get(0);
                    originalLang = ((MediaStreamInfo)mfs).getLanguage();
                    if (!((MediaStreamInfo)mfs).isForced()) break block21;
                    forced = ".forced";
                    break block21;
                }
                mfs = m.getMediaFiles(MediaFileType.VIDEO);
                String shortname = sub.getBasename().toLowerCase(Locale.ROOT);
                if (ListUtils.isNotEmpty(mfs)) {
                    shortname = sub.getBasename().toLowerCase(Locale.ROOT).replace(m.getVideoBasenameWithoutStacking(), "");
                }
                if (sub.getFilename().toLowerCase(Locale.ROOT).contains("forced")) {
                    forced = ".forced";
                    shortname = shortname.replaceAll("\\p{Punct}*forced", "");
                }
                for (String s : langArray) {
                    if (!LanguageUtils.doesStringEndWithLanguage(shortname, s)) continue;
                    originalLang = s;
                    LOGGER.trace("found language '{}' in subtitle", (Object)s);
                    break;
                }
            }
            if (!MovieModuleManager.SETTINGS.isSubtitleWithoutLanguageTag() || subtitleFiles.size() > 1) {
                lang = LanguageStyle.getLanguageCodeForStyle(originalLang, MovieModuleManager.SETTINGS.getSubtitleLanguageStyle());
                if (StringUtils.isBlank((CharSequence)lang)) {
                    lang = originalLang;
                }
            } else {
                lang = "";
            }
            String newSubName = "";
            if (sub.getStacking() == 0) {
                MediaFile mf = m.getMediaFiles(MediaFileType.VIDEO).get(0);
                newSubName = mf.getBasename();
                if (!lang.isEmpty()) {
                    newSubName = newSubName + "." + lang;
                }
                newSubName = newSubName + forced;
            } else {
                for (MediaFile mf : m.getMediaFiles(MediaFileType.VIDEO)) {
                    if (mf.getStacking() != sub.getStacking()) continue;
                    newSubName = mf.getBasename();
                    if (!lang.isEmpty()) {
                        newSubName = newSubName + "." + lang;
                    }
                    newSubName = newSubName + forced;
                }
            }
            newSubName = newSubName + "." + sub.getExtension();
            Path newFile = m.getPathNIO().resolve(newSubName);
            try {
                boolean ok = Utils.moveFileSafe(sub.getFileAsPath(), newFile);
                if (ok) {
                    if (sub.getFilename().endsWith(".sub")) {
                        try {
                            Path oldidx = sub.getFileAsPath().resolveSibling(sub.getFilename().replaceFirst("sub$", "idx"));
                            Path newidx = newFile.resolveSibling(newFile.getFileName().toString().replaceFirst("sub$", "idx"));
                            Utils.moveFileSafe(oldidx, newidx);
                        }
                        catch (Exception oldidx) {
                            // empty catch block
                        }
                    }
                    m.removeFromMediaFiles(sub);
                    MediaFile mf = new MediaFile(newFile);
                    MediaFileSubtitle mfs = new MediaFileSubtitle();
                    if (!lang.isEmpty()) {
                        mfs.setLanguage(lang);
                    }
                    if (!forced.isEmpty()) {
                        mfs.setForced(true);
                    }
                    mfs.setCodec(sub.getExtension());
                    mf.setContainerFormat(sub.getExtension());
                    mf.addSubtitle(mfs);
                    m.addToMediaFiles(mf);
                    continue;
                }
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, sub.getFilename(), "message.renamer.failedrename"));
            }
            catch (Exception e) {
                LOGGER.error("error moving subtitles", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)sub.getFilename(), "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        m.saveToDb();
    }

    private static void removeEmptySubfolders(Movie movie) {
        if (movie.isMultiMovieDir()) {
            return;
        }
        try {
            Utils.deleteEmptyDirectoryRecursive(movie.getPathNIO());
        }
        catch (IOException e) {
            LOGGER.warn("could not delete empty subfolders: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void renameMovie(Movie movie) {
        void var13_43;
        void var10_15;
        Object srcDir;
        if (MovieModuleManager.SETTINGS.getRenamerPathname().isEmpty() && MovieModuleManager.SETTINGS.getRenamerFilename().isEmpty()) {
            LOGGER.info("NOT renaming Movie '{}' - renaming patterns are empty!", (Object)movie.getTitle());
            return;
        }
        boolean posterRenamed = false;
        boolean fanartRenamed = false;
        boolean downloadMissingArtworks = false;
        if (StringUtils.isEmpty((CharSequence)movie.getDataSource())) {
            LOGGER.error("no Datasource set");
            return;
        }
        if (movie.getTitle().isEmpty()) {
            LOGGER.error("won't rename movie '{}' / '{}' not even title is set?", (Object)movie.getPathNIO(), (Object)movie.getTitle());
            return;
        }
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>();
        LOGGER.info("Renaming movie: {}", (Object)movie.getTitle());
        LOGGER.debug("movie year: {}", (Object)movie.getYear());
        LOGGER.debug("movie path: {}", (Object)movie.getPathNIO());
        LOGGER.debug("movie isDisc?: {}", (Object)movie.isDisc());
        LOGGER.debug("movie isMulti?: {}", (Object)movie.isMultiMovieDir());
        if (movie.getMovieSet() != null) {
            LOGGER.debug("movieset: {}", (Object)movie.getMovieSet().getTitle());
        }
        LOGGER.debug("path expression: {}", (Object)MovieModuleManager.SETTINGS.getRenamerPathname());
        LOGGER.debug("file expression: {}", (Object)MovieModuleManager.SETTINGS.getRenamerFilename());
        String newPathname = MovieRenamer.createDestinationForFoldername(MovieModuleManager.SETTINGS.getRenamerPathname(), movie);
        String oldPathname = movie.getPathNIO().toString();
        if (!newPathname.isEmpty()) {
            newPathname = Paths.get(movie.getDataSource(), newPathname).toString();
            srcDir = movie.getPathNIO();
            Path destDir = Paths.get(newPathname, new String[0]);
            if (!srcDir.toAbsolutePath().toString().equals(destDir.toAbsolutePath().toString())) {
                boolean bl;
                boolean bl2 = false;
                if (!MovieRenamer.isFolderPatternUnique(MovieModuleManager.SETTINGS.getRenamerPathname())) {
                    bl = true;
                }
                LOGGER.debug("movie willBeMulti?: {}", (Object)bl);
                if (!movie.isMultiMovieDir() && !bl) {
                    boolean ok = false;
                    try {
                        ok = Utils.moveDirectorySafe((Path)srcDir, destDir);
                        if (ok) {
                            movie.setMultiMovieDir(false);
                            movie.updateMediaFilePath((Path)srcDir, destDir);
                            movie.setPath(newPathname);
                            movie.saveToDb();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("error moving folder: ", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, srcDir, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                    }
                    if (!ok) {
                        LOGGER.error("Could not move to destination '{}' - NOT renaming folder", (Object)destDir);
                        return;
                    }
                } else if (movie.isMultiMovieDir() && !bl) {
                    LOGGER.trace("Upgrading movie into it's own dir :) - {}", (Object)newPathname);
                    if (!Files.exists(destDir, new LinkOption[0])) {
                        try {
                            Files.createDirectories(destDir, new FileAttribute[0]);
                        }
                        catch (Exception e) {
                            LOGGER.error("Could not create destination '{}' - NOT renaming folder ('upgrade' movie)", (Object)destDir);
                            return;
                        }
                    } else {
                        LOGGER.error("Directory already exists! '{}' - NOT renaming folder ('upgrade' movie)", (Object)destDir);
                        return;
                    }
                    movie.setMultiMovieDir(false);
                    downloadMissingArtworks = true;
                } else {
                    LOGGER.trace("New movie path is a MMD :( - {}", (Object)newPathname);
                    if (!Files.exists(destDir, new LinkOption[0])) {
                        try {
                            Files.createDirectories(destDir, new FileAttribute[0]);
                        }
                        catch (Exception e) {
                            LOGGER.error("Could not create destination '{}' - NOT renaming folder ('MMD' movie)", (Object)destDir);
                            return;
                        }
                    }
                    movie.setMultiMovieDir(true);
                }
            }
        } else {
            LOGGER.info("Folder rename settings were empty - NOT renaming folder");
            newPathname = movie.getPathNIO().toString();
        }
        srcDir = MovieNfoNaming.values();
        int destDir = ((MovieNfoNaming[])srcDir).length;
        boolean bl = false;
        while (var10_15 < destDir) {
            MovieNfoNaming s = srcDir[var10_15];
            String nfoFilename = movie.getNfoFilename(s);
            if (!StringUtils.isBlank((CharSequence)nfoFilename)) {
                MediaFile mediaFile = new MediaFile(movie.getPathNIO().resolve(nfoFilename), MediaFileType.NFO);
                cleanup.add(mediaFile);
            }
            ++var10_15;
        }
        ArrayList<Enum> fileNamings = new ArrayList<Enum>();
        fileNamings.addAll(Arrays.asList(MoviePosterNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieFanartNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieBannerNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieClearartNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieLogoNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieClearlogoNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieThumbNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieDiscartNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieKeyartNaming.values()));
        for (IFileNaming iFileNaming : fileNamings) {
            for (String ext : KNOWN_IMAGE_FILE_EXTENSIONS) {
                MediaFile mediaFile = new MediaFile(movie.getPathNIO().resolve(MovieArtworkHelper.getArtworkFilename(movie, iFileNaming, ext)));
                cleanup.add(mediaFile);
            }
        }
        for (MediaFile mediaFile : movie.getMediaFiles()) {
            cleanup.add(new MediaFile(mediaFile));
        }
        cleanup.removeAll(Collections.singleton(null));
        String newVideoBasename = "";
        if (!MovieRenamer.isFilePatternValid()) {
            newVideoBasename = movie.getVideoBasenameWithoutStacking();
            LOGGER.warn("Filepattern is not valid - NOT renaming files!");
        } else {
            MediaFile mediaFile = MovieRenamer.generateFilename(movie, movie.getMediaFiles(MediaFileType.VIDEO).get(0), newVideoBasename).get(0);
            newVideoBasename = FilenameUtils.getBaseName((String)mediaFile.getFilenameWithoutStacking());
        }
        LOGGER.debug("Our new basename for renaming: {}", (Object)newVideoBasename);
        for (MediaFile vid : movie.getMediaFiles(MediaFileType.VIDEO)) {
            LOGGER.trace("Rename 1:1 {} - {}", (Object)vid.getType(), (Object)vid.getFileAsPath());
            MediaFile newMF = MovieRenamer.generateFilename(movie, vid, newVideoBasename).get(0);
            boolean bl3 = MovieRenamer.moveFile(vid.getFileAsPath(), newMF.getFileAsPath());
            if (bl3) {
                vid.setFile(newMF.getFileAsPath());
            }
            needed.add(vid);
        }
        ArrayList<MediaFile> arrayList = new ArrayList<MediaFile>();
        arrayList.add(movie.getNewestMediaFilesOfType(MediaFileType.FANART));
        arrayList.add(movie.getNewestMediaFilesOfType(MediaFileType.POSTER));
        arrayList.add(movie.getNewestMediaFilesOfType(MediaFileType.BANNER));
        arrayList.add(movie.getNewestMediaFilesOfType(MediaFileType.CLEARART));
        arrayList.add(movie.getNewestMediaFilesOfType(MediaFileType.THUMB));
        arrayList.add(movie.getNewestMediaFilesOfType(MediaFileType.LOGO));
        arrayList.add(movie.getNewestMediaFilesOfType(MediaFileType.CLEARLOGO));
        arrayList.add(movie.getNewestMediaFilesOfType(MediaFileType.DISC));
        arrayList.add(movie.getNewestMediaFilesOfType(MediaFileType.KEYART));
        arrayList.removeAll(Collections.singleton(null));
        for (Object mf : arrayList) {
            LOGGER.trace("Rename 1:N {} - {}", (Object)((MediaFile)mf).getType(), (Object)((MediaFile)mf).getFileAsPath());
            List<MediaFile> list = MovieRenamer.generateFilename(movie, (MediaFile)mf, newVideoBasename);
            for (MediaFile newMF : list) {
                posterRenamed = true;
                fanartRenamed = true;
                boolean ok = MovieRenamer.copyFile(((MediaFile)mf).getFileAsPath(), newMF.getFileAsPath());
                if (!ok) continue;
                needed.add(newMF);
            }
        }
        MediaFile nfo = new MediaFile();
        for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.NFO)) {
            if (mediaFile.getFiledate() < nfo.getFiledate() || !MovieConnectors.isValidNFO(mediaFile.getFileAsPath())) continue;
            nfo = new MediaFile(mediaFile);
        }
        if (nfo.getFiledate() > 0L) {
            List<MediaFile> newNFOs = MovieRenamer.generateFilename(movie, nfo, newVideoBasename);
            if (!newNFOs.isEmpty()) {
                Iterator<MediaFile> iterator = newNFOs.iterator();
                while (iterator.hasNext()) {
                    MediaFile newNFO = iterator.next();
                    boolean ok = MovieRenamer.copyFile(nfo.getFileAsPath(), newNFO.getFileAsPath());
                    if (!ok) continue;
                    needed.add(newNFO);
                }
            } else {
                cleanup.add(nfo);
            }
        } else {
            LOGGER.trace("No valid NFO found for this movie");
        }
        for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.NFO)) {
            if (MovieConnectors.isValidNFO(mediaFile.getFileAsPath())) {
                cleanup.add(mediaFile);
                continue;
            }
            if (MovieModuleManager.SETTINGS.isRenamerNfoCleanup()) {
                cleanup.add(mediaFile);
                continue;
            }
            needed.add(mediaFile);
        }
        ArrayList<MediaFile> arrayList2 = new ArrayList<MediaFile>(movie.getMediaFilesExceptType(MediaFileType.VIDEO, MediaFileType.NFO, MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.CLEARART, MediaFileType.THUMB, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.DISC, MediaFileType.KEYART, MediaFileType.SUBTITLE));
        arrayList2.removeAll(Collections.singleton(null));
        for (MediaFile mediaFile : arrayList2) {
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            List<MediaFile> newMFs = MovieRenamer.generateFilename(movie, mediaFile, newVideoBasename);
            newMFs.removeAll(Collections.singleton(null));
            for (MediaFile newMF : newMFs) {
                boolean ok = MovieRenamer.copyFile(mediaFile.getFileAsPath(), newMF.getFileAsPath());
                if (ok) {
                    needed.add(newMF);
                    continue;
                }
                needed.add(mediaFile);
            }
        }
        needed.addAll(movie.getMediaFiles(MediaFileType.SUBTITLE));
        for (MediaFile mediaFile : movie.getMediaFiles()) {
            if (!mediaFile.isGraphic()) continue;
            ImageCache.invalidateCachedImage(mediaFile);
        }
        LinkedHashSet newMFs = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll(newMFs);
        movie.removeAllMediaFiles();
        movie.addToMediaFiles(needed);
        movie.setPath(newPathname);
        movie.saveToDb();
        MovieRenamer.renameSubtitles(movie);
        movie.gatherMediaFileInformation(false);
        if (MovieModuleManager.SETTINGS.getMovieConnector() == MovieConnectors.MP && (posterRenamed || fanartRenamed)) {
            movie.writeNFO();
        }
        movie.saveToDb();
        LOGGER.info("Cleanup...");
        if (movie.isMultiMovieDir()) {
            List<Path> list = Utils.listFiles(movie.getPathNIO());
        } else {
            List<Path> list = Utils.listFilesRecursive(movie.getPathNIO());
        }
        var13_43.addAll(Utils.listFiles(Paths.get(oldPathname, new String[0])));
        for (int i = cleanup.size() - 1; i >= 0; --i) {
            MediaFile cl = (MediaFile)cleanup.get(i);
            if (needed.contains(cl)) continue;
            if (cl.getFileAsPath().equals(Paths.get(movie.getDataSource(), new String[0])) || cl.getFileAsPath().equals(movie.getPathNIO()) || cl.getFileAsPath().equals(Paths.get(oldPathname, new String[0]))) {
                LOGGER.warn("Wohoo! We tried to remove complete datasource / movie folder. Nooo way...! {}: {}", (Object)cl.getType(), (Object)cl.getFileAsPath());
                continue;
            }
            if (var13_43.contains(cl.getFileAsPath())) {
                LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
                Utils.deleteFileWithBackup(cl.getFileAsPath(), movie.getDataSource());
                if (cl.isGraphic()) {
                    ImageCache.invalidateCachedImage(cl);
                }
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(cl.getFileAsPath().getParent());){
                if (directoryStream.iterator().hasNext()) continue;
                LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                Files.delete(cl.getFileAsPath().getParent());
                continue;
            }
            catch (IOException e) {
                LOGGER.warn("could not search for empty dir: {}", (Object)e.getMessage());
            }
        }
        MovieRenamer.removeEmptySubfolders(movie);
        if (downloadMissingArtworks) {
            LOGGER.debug("Yay - movie upgrade :) download missing artworks");
            MovieArtworkHelper.downloadMissingArtwork(movie);
            movie.writeActorImages();
        }
    }

    public static List<MediaFile> generateFilename(Movie movie, MediaFile mf, String videoFileName) {
        ArrayList<MediaFile> newFiles = new ArrayList<MediaFile>();
        boolean newDestIsMultiMovieDir = movie.isMultiMovieDir();
        String newPathname = "";
        String pattern = MovieModuleManager.SETTINGS.getRenamerPathname();
        if (!pattern.isEmpty()) {
            newDestIsMultiMovieDir = !MovieRenamer.isFolderPatternUnique(pattern);
            newPathname = MovieRenamer.createDestinationForFoldername(pattern, movie);
        } else {
            newPathname = Utils.relPath(Paths.get(movie.getDataSource(), new String[0]), movie.getPathNIO());
        }
        Path newMovieDir = Paths.get(movie.getDataSource(), newPathname);
        String newFilename = videoFileName;
        if (newFilename == null || newFilename.isEmpty()) {
            newFilename = MovieRenamer.createDestinationForFilename(MovieModuleManager.SETTINGS.getRenamerFilename(), movie);
        }
        MediaFile defaultMF = new MediaFile(mf);
        defaultMF.replacePathForRenamedFolder(movie.getPathNIO(), newMovieDir);
        if (!MovieRenamer.isFilePatternValid() && !movie.isDisc()) {
            newFiles.add(defaultMF);
            return newFiles;
        }
        switch (mf.getType()) {
            case VIDEO: {
                MediaFile vid = new MediaFile(mf);
                if (movie.isDisc() || mf.isDiscFile()) {
                    vid.replacePathForRenamedFolder(movie.getPathNIO(), newMovieDir);
                } else {
                    newFilename = newFilename + MovieRenamer.getStackingString(mf);
                    newFilename = newFilename + "." + mf.getExtension();
                    vid.setFile(newMovieDir.resolve(newFilename));
                }
                newFiles.add(vid);
                break;
            }
            case TRAILER: {
                if (MovieModuleManager.SETTINGS.getTrailerFilenames().isEmpty()) break;
                List<MovieTrailerNaming> trailernames = new ArrayList<MovieTrailerNaming>();
                if (newDestIsMultiMovieDir) {
                    trailernames.add(MovieTrailerNaming.FILENAME_TRAILER);
                } else if (movie.isDisc()) {
                    trailernames.add(MovieTrailerNaming.FILENAME_TRAILER);
                } else {
                    trailernames = MovieModuleManager.SETTINGS.getTrailerFilenames();
                }
                for (MovieTrailerNaming name : trailernames) {
                    String newTrailerName = movie.getTrailerFilename(name, newFilename + ".avi");
                    if (newTrailerName.isEmpty()) continue;
                    MediaFile trail = new MediaFile(mf);
                    trail.setFile(newMovieDir.resolve(newTrailerName + "." + mf.getExtension()));
                    newFiles.add(trail);
                }
                break;
            }
            case SAMPLE: {
                MediaFile sample = new MediaFile(mf);
                newFilename = newFilename + "-sample." + mf.getExtension();
                sample.setFile(newMovieDir.resolve(newFilename));
                newFiles.add(sample);
                break;
            }
            case MEDIAINFO: {
                MediaFile mi = new MediaFile(mf);
                if (movie.isDisc()) {
                    mi.replacePathForRenamedFolder(movie.getPathNIO(), newMovieDir);
                    newFiles.add(mi);
                    break;
                }
                newFilename = newFilename + MovieRenamer.getStackingString(mf);
                newFilename = newFilename + "-mediainfo." + mf.getExtension();
                mi.setFile(newMovieDir.resolve(newFilename));
                newFiles.add(mi);
                break;
            }
            case VSMETA: {
                MediaFile meta = new MediaFile(mf);
                if (movie.isDisc()) {
                    meta.setFile(newMovieDir.resolve(meta.getFilename()));
                    newFiles.add(meta);
                    break;
                }
                newFilename = newFilename + MovieRenamer.getStackingString(mf);
                String videoExt = FilenameUtils.getExtension((String)FilenameUtils.getBaseName((String)mf.getFilename()));
                newFilename = newFilename + "." + videoExt + ".vsmeta";
                meta.setFile(newMovieDir.resolve(newFilename));
                newFiles.add(meta);
                break;
            }
            case SUBTITLE: {
                List<MediaFileSubtitle> mfsl = mf.getSubtitles();
                List<MediaFile> subtitleFiles = movie.getMediaFiles(MediaFileType.SUBTITLE);
                if (!MovieModuleManager.SETTINGS.isSubtitleWithoutLanguageTag() || subtitleFiles.size() > 1) {
                    newFilename = newFilename + MovieRenamer.getStackingString(mf);
                    if (mfsl != null && !mfsl.isEmpty()) {
                        MediaFileSubtitle mfs = mfsl.get(0);
                        if (!mfs.getLanguage().isEmpty()) {
                            String lang = LanguageStyle.getLanguageCodeForStyle(mfs.getLanguage(), MovieModuleManager.SETTINGS.getSubtitleLanguageStyle());
                            if (StringUtils.isBlank((CharSequence)lang)) {
                                lang = mfs.getLanguage();
                            }
                            newFilename = newFilename + "." + lang;
                        }
                        if (mfs.isForced()) {
                            newFilename = newFilename + ".forced";
                        }
                    }
                }
                newFilename = newFilename + "." + mf.getExtension();
                MediaFile sub = new MediaFile(mf);
                sub.setFile(newMovieDir.resolve(newFilename));
                newFiles.add(sub);
                break;
            }
            case NFO: {
                if (MovieModuleManager.SETTINGS.getNfoFilenames().isEmpty()) break;
                if (MovieConnectors.isValidNFO(mf.getFileAsPath())) {
                    List<Object> nfonames = new ArrayList<MovieNfoNaming>();
                    if (newDestIsMultiMovieDir) {
                        nfonames.add((Object)MovieNfoNaming.FILENAME_NFO);
                    } else if (movie.isDisc()) {
                        nfonames.add((Object)MovieNfoNaming.FILENAME_NFO);
                        nfonames.add((Object)MovieNfoNaming.MOVIE_NFO);
                    } else {
                        nfonames = MovieModuleManager.SETTINGS.getNfoFilenames();
                    }
                    for (MovieNfoNaming movieNfoNaming : nfonames) {
                        String newNfoName = movie.getNfoFilename(movieNfoNaming, newFilename + ".avi");
                        if (newNfoName.isEmpty()) continue;
                        MediaFile nfo = new MediaFile(mf);
                        nfo.setFile(newMovieDir.resolve(newNfoName));
                        newFiles.add(nfo);
                    }
                    break;
                }
                if (MovieModuleManager.SETTINGS.isRenamerNfoCleanup()) break;
                newFiles.add(new MediaFile(mf));
                break;
            }
            case POSTER: {
                for (MoviePosterNaming name : MovieArtworkHelper.getPosterNamesForMovie(movie)) {
                    String string = name.getFilename(newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    MediaFile pos = new MediaFile(mf);
                    pos.setFile(newMovieDir.resolve(string));
                    newFiles.add(pos);
                }
                break;
            }
            case FANART: {
                for (MovieFanartNaming name : MovieArtworkHelper.getFanartNamesForMovie(movie)) {
                    String string = name.getFilename(newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    MediaFile fan = new MediaFile(mf);
                    fan.setFile(newMovieDir.resolve(string));
                    newFiles.add(fan);
                }
                break;
            }
            case BANNER: {
                for (MovieBannerNaming name : MovieArtworkHelper.getBannerNamesForMovie(movie)) {
                    String string = name.getFilename(newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    MediaFile banner = new MediaFile(mf);
                    banner.setFile(newMovieDir.resolve(string));
                    newFiles.add(banner);
                }
                break;
            }
            case CLEARART: {
                for (MovieClearartNaming name : MovieArtworkHelper.getClearartNamesForMovie(movie)) {
                    String string = name.getFilename(newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    MediaFile clearart = new MediaFile(mf);
                    clearart.setFile(newMovieDir.resolve(string));
                    newFiles.add(clearart);
                }
                break;
            }
            case DISC: {
                for (MovieDiscartNaming name : MovieArtworkHelper.getDiscartNamesForMovie(movie)) {
                    String string = name.getFilename(newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    MediaFile discart = new MediaFile(mf);
                    discart.setFile(newMovieDir.resolve(string));
                    newFiles.add(discart);
                }
                break;
            }
            case LOGO: {
                for (MovieLogoNaming name : MovieArtworkHelper.getLogoNamesForMovie(movie)) {
                    String string = name.getFilename(newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    MediaFile logo = new MediaFile(mf);
                    logo.setFile(newMovieDir.resolve(string));
                    newFiles.add(logo);
                }
                break;
            }
            case CLEARLOGO: {
                for (MovieClearlogoNaming name : MovieArtworkHelper.getClearlogoNamesForMovie(movie)) {
                    String string = name.getFilename(newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    MediaFile clearlogo = new MediaFile(mf);
                    clearlogo.setFile(newMovieDir.resolve(string));
                    newFiles.add(clearlogo);
                }
                break;
            }
            case THUMB: {
                for (MovieThumbNaming name : MovieArtworkHelper.getThumbNamesForMovie(movie)) {
                    String string = name.getFilename(newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    MediaFile thumb = new MediaFile(mf);
                    thumb.setFile(newMovieDir.resolve(string));
                    newFiles.add(thumb);
                }
                break;
            }
            case KEYART: {
                for (MovieKeyartNaming name : MovieArtworkHelper.getKeyartNamesForMovie(movie)) {
                    String string = name.getFilename(newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    MediaFile key = new MediaFile(mf);
                    key.setFile(newMovieDir.resolve(string));
                    newFiles.add(key);
                }
                break;
            }
            case EXTRAFANART: 
            case EXTRATHUMB: {
                if (newDestIsMultiMovieDir) break;
                newFiles.add(defaultMF);
                break;
            }
            default: {
                newFiles.add(defaultMF);
            }
        }
        return newFiles;
    }

    private static String getArtworkExtension(MediaFile mf) {
        String ext = mf.getExtension().replaceAll("jpeg", "jpg");
        if (ext.equalsIgnoreCase("tbn")) {
            String cont = mf.getContainerFormat();
            if (cont.equalsIgnoreCase("PNG")) {
                ext = "png";
            } else if (cont.equalsIgnoreCase("JPEG")) {
                ext = "jpg";
            }
        }
        return ext;
    }

    private static String getStackingString(MediaFile mf) {
        String delimiter = " ";
        if (MovieModuleManager.SETTINGS.isRenamerFilenameSpaceSubstitution()) {
            delimiter = MovieModuleManager.SETTINGS.getRenamerFilenameSpaceReplacement();
        }
        if (!mf.getStackingMarker().isEmpty()) {
            return delimiter + mf.getStackingMarker();
        }
        if (mf.getStacking() != 0) {
            return delimiter + "CD" + mf.getStacking();
        }
        return "";
    }

    public static String createDestinationForFilename(String template, Movie movie) {
        return MovieRenamer.createDestination(template, movie, true);
    }

    public static String createDestinationForFoldername(String template, Movie movie) {
        return MovieRenamer.createDestination(template, movie, false);
    }

    private static String replaceOptionalVariable(String s, Movie movie, boolean forFilename) {
        Pattern regex = Pattern.compile("\\$.{1}");
        Matcher mat = regex.matcher(s);
        if (mat.find()) {
            String rep = MovieRenamer.createDestination(mat.group(), movie, forFilename);
            if (rep.isEmpty()) {
                return "";
            }
            return s.replace(mat.group(), rep);
        }
        return "";
    }

    public static String getTokenValue(Movie movie, String token) {
        try {
            Engine engine = Engine.createEngine();
            engine.registerRenderer(Number.class, (Renderer)new ZeroNumberRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedDateRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedUpperCaseRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedLowerCaseRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedTitleCaseRenderer());
            engine.registerNamedRenderer((NamedRenderer)new MovieNamedFirstCharacterRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedArrayRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedFilesizeRenderer());
            engine.setModelAdaptor((ModelAdaptor)new MovieRenamerModelAdaptor());
            HashMap<String, MediaEntity> root = new HashMap<String, MediaEntity>();
            root.put("movie", movie);
            if (movie.getMovieSet() != null && (movie.getMovieSet().getMovies().size() > 1 || MovieModuleManager.SETTINGS.isRenamerCreateMoviesetForSingleMovie())) {
                root.put("movieSet", movie.getMovieSet());
            }
            return engine.transform(MovieRenamer.morphTemplate(token), root);
        }
        catch (Exception e) {
            LOGGER.warn("unable to process token: {}", (Object)token);
            return token;
        }
    }

    protected static String getFirstAlphaNum(String text) {
        Matcher m;
        if (StringUtils.isNotBlank((CharSequence)text) && (m = ALPHANUM.matcher(text)).find()) {
            return m.group(1).toUpperCase(Locale.ROOT);
        }
        return "";
    }

    public static String createDestination(String template, Movie movie, boolean forFilename) {
        String newDestination = MovieRenamer.getTokenValue(movie, template);
        newDestination = newDestination.replaceAll("\\([ ]?\\)", "");
        newDestination = newDestination.replaceAll("\\[[ ]?\\]", "");
        newDestination = newDestination.replaceAll("\\{[ ]?\\}", "");
        if (SystemUtils.IS_OS_WINDOWS) {
            if (!forFilename) {
                newDestination = newDestination.replaceAll("\\s+\\\\", "\\\\");
                newDestination = newDestination.replaceAll("\\\\\\s+", "\\\\");
                newDestination = newDestination.replaceAll("[ \\.\\-_]+\\\\", "\\\\");
            }
            newDestination = newDestination.replaceAll("\\\\{2,}", "\\\\");
            newDestination = newDestination.replaceAll("^\\\\", "");
        } else {
            if (!forFilename) {
                newDestination = newDestination.replaceAll("\\s+/", "/");
                newDestination = newDestination.replaceAll("/\\s+", "/");
                newDestination = newDestination.replaceAll("[ \\.\\-_]+/", "/");
            }
            newDestination = newDestination.replaceAll("/{2,}", "/");
            newDestination = newDestination.replaceAll("^/", "");
        }
        if (forFilename) {
            newDestination = MovieRenamer.replacePathSeparators(newDestination);
        }
        newDestination = newDestination.replaceAll(" +", " ").trim();
        if (forFilename && MovieModuleManager.SETTINGS.isRenamerFilenameSpaceSubstitution()) {
            String replacement = MovieModuleManager.SETTINGS.getRenamerFilenameSpaceReplacement();
            newDestination = newDestination.replace(" ", replacement);
            newDestination = newDestination.replaceAll(Pattern.quote(replacement) + "+", replacement);
        } else if (!forFilename && MovieModuleManager.SETTINGS.isRenamerPathnameSpaceSubstitution()) {
            String replacement = MovieModuleManager.SETTINGS.getRenamerPathnameSpaceReplacement();
            newDestination = newDestination.replace(" ", replacement);
            newDestination = newDestination.replaceAll(Pattern.quote(replacement) + "+", replacement);
        }
        newDestination = newDestination.replaceAll("^[ \\.\\-]+", "");
        newDestination = newDestination.replaceAll("[ \\.\\-_]+$", "");
        if (MovieModuleManager.SETTINGS.isAsciiReplacement()) {
            newDestination = StrgUtils.convertToAscii(newDestination, false);
        }
        newDestination = newDestination.replace(": ", " - ");
        newDestination = newDestination.replace(":", "-");
        return newDestination.trim();
    }

    static boolean moveFile(Path oldFilename, Path newFilename) {
        try {
            boolean ok;
            if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
            }
            if (ok = Utils.moveFileSafe(oldFilename, newFilename)) {
                return true;
            }
            LOGGER.error("Could not move MF '{}' to '{}'", (Object)oldFilename, (Object)newFilename);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("error moving file", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)oldFilename, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            return false;
        }
    }

    static boolean copyFile(Path oldFilename, Path newFilename) {
        if (!oldFilename.toAbsolutePath().toString().equals(newFilename.toAbsolutePath().toString())) {
            LOGGER.info("copy file {} to {}", (Object)oldFilename, (Object)newFilename);
            if (oldFilename.equals(newFilename)) {
                return MovieRenamer.moveFile(oldFilename, newFilename);
            }
            try {
                if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                    Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
                }
                Utils.copyFileSafe(oldFilename, newFilename, true);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isFolderPatternUnique(String pattern) {
        return TITLE_PATTERN.matcher(pattern).find() && YEAR_ID_PATTERN.matcher(pattern).find();
    }

    public static boolean isFilePatternValid() {
        return MovieRenamer.isFilePatternValid(MovieModuleManager.SETTINGS.getRenamerFilename());
    }

    public static boolean isFilePatternValid(String pattern) {
        return TITLE_PATTERN.matcher(pattern).find();
    }

    public static String replaceInvalidCharacters(String source) {
        String result = source;
        if ("-".equals(MovieModuleManager.SETTINGS.getRenamerColonReplacement())) {
            result = result.replace(": ", " - ");
            result = result.replace(":", "-");
        } else {
            result = result.replace(":", MovieModuleManager.SETTINGS.getRenamerColonReplacement());
        }
        return result.replaceAll("([\":<>|?*])", "");
    }

    public static String replacePathSeparators(String source) {
        String result = source.replaceAll("\\/", " ");
        return result.replaceAll("\\\\", " ");
    }

    private static class MovieNamedFirstCharacterRenderer
    implements NamedRenderer {
        private MovieNamedFirstCharacterRenderer() {
        }

        public String render(Object o, String s, Locale locale, Map<String, Object> map) {
            if (o instanceof String && StringUtils.isNotBlank((CharSequence)((String)o))) {
                String first;
                String source = (String)o;
                if (MovieModuleManager.SETTINGS.isAsciiReplacement()) {
                    source = StrgUtils.convertToAscii(source, false);
                }
                if ((first = source.trim().substring(0, 1)).matches("[\\p{L}]")) {
                    return first.toUpperCase(Locale.ROOT);
                }
                return "#";
            }
            if (o instanceof Number) {
                return "#";
            }
            if (o instanceof Date) {
                return "#";
            }
            return "";
        }

        public String getName() {
            return "first";
        }

        public RenderFormatInfo getFormatInfo() {
            return null;
        }

        public Class<?>[] getSupportedClasses() {
            return new Class[]{Date.class, String.class, Integer.class, Long.class};
        }
    }

    public static class MovieRenamerModelAdaptor
    extends TmmModelAdaptor {
        public Object getValue(Map<String, Object> model, String expression) {
            Object value = super.getValue(model, expression);
            if (value instanceof String) {
                value = MovieRenamer.replaceInvalidCharacters((String)value);
            }
            return value;
        }

        public Object getValue(TemplateContext context, Token token, List<String> segments, String expression) {
            Object value = super.getValue(context, token, segments, expression);
            if (value instanceof String) {
                value = MovieRenamer.replaceInvalidCharacters((String)value);
                if (!token.getText().contains("parent")) {
                    value = MovieRenamer.replacePathSeparators((String)value);
                }
            }
            return value;
        }
    }
}

