/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.core.tasks.TrailerDownloadTask;
import org.tinymediamanager.core.tasks.YTDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;

public class MovieHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieHelpers.class);

    private MovieHelpers() {
    }

    public static MediaCertification parseCertificationStringForMovieSetupCountry(String name) {
        MediaCertification cert = MediaCertification.UNKNOWN;
        if ((name = name.trim()).contains("/")) {
            String[] cs;
            String[] countries;
            for (String c : countries = name.split("/")) {
                if ((c = c.trim()).contains(":")) {
                    cs = c.split(":");
                    cert = MediaCertification.getCertification(MovieModuleManager.SETTINGS.getCertificationCountry(), cs[1]);
                    if (cert == MediaCertification.UNKNOWN) continue;
                    return cert;
                }
                cert = MediaCertification.getCertification(MovieModuleManager.SETTINGS.getCertificationCountry(), c);
                if (cert == MediaCertification.UNKNOWN) continue;
                return cert;
            }
            for (String c : countries) {
                if (!((c = c.trim()).contains(":") ? (cert = MediaCertification.findCertification((cs = c.split(":"))[1])) != MediaCertification.UNKNOWN : (cert = MediaCertification.findCertification(c)) != MediaCertification.UNKNOWN)) continue;
                return cert;
            }
        } else if (name.contains(":")) {
            String[] cs = name.split(":");
            cert = MediaCertification.getCertification(MovieModuleManager.SETTINGS.getCertificationCountry(), cs[1].trim());
        } else {
            cert = MediaCertification.getCertification(MovieModuleManager.SETTINGS.getCertificationCountry(), name.trim());
        }
        if (cert == MediaCertification.UNKNOWN) {
            cert = MediaCertification.findCertification(name);
        }
        return cert;
    }

    public static void startAutomaticTrailerDownload(Movie movie) {
        if (MovieModuleManager.SETTINGS.isUseTrailerPreference() && MovieModuleManager.SETTINGS.isAutomaticTrailerDownload() && movie.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !movie.getTrailer().isEmpty()) {
            MovieHelpers.downloadBestTrailer(movie);
        }
    }

    public static void downloadBestTrailer(Movie movie) {
        MediaTrailer trailer = movie.getTrailer().get(0);
        MovieHelpers.downloadTrailer(movie, trailer);
    }

    public static void downloadTrailer(final Movie movie, MediaTrailer trailer) {
        List<Object> trailernames = new ArrayList<MovieTrailerNaming>();
        if (movie.isMultiMovieDir()) {
            trailernames.add(MovieTrailerNaming.FILENAME_TRAILER);
        } else {
            trailernames = MovieModuleManager.SETTINGS.getTrailerFilenames();
        }
        final String filename = !trailernames.isEmpty() ? movie.getTrailerFilename((MovieTrailerNaming)trailernames.get(0)) : movie.getTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        try {
            Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(trailer.getUrl());
            if (matcher.matches()) {
                YTDownloadTask task = new YTDownloadTask(trailer, MovieModuleManager.SETTINGS.getTrailerQuality()){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return movie.getPathNIO().resolve(filename);
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return movie;
                    }
                };
                TmmTaskManager.getInstance().addDownloadTask(task);
            } else {
                TrailerDownloadTask task = new TrailerDownloadTask(trailer){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return movie.getPathNIO().resolve(filename);
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return movie;
                    }
                };
                TmmTaskManager.getInstance().addDownloadTask(task);
            }
        }
        catch (Exception e) {
            LOGGER.error("could not start trailer download: {}", (Object)e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
        }
    }
}

