/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.jmte.NamedDateRenderer;
import org.tinymediamanager.core.jmte.NamedFilesizeRenderer;
import org.tinymediamanager.core.jmte.NamedFirstCharacterRenderer;
import org.tinymediamanager.core.jmte.NamedNumberRenderer;
import org.tinymediamanager.core.jmte.NamedUpperCaseRenderer;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;

public class MovieExporter
extends MediaEntityExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieExporter.class);

    public MovieExporter(Path pathToTemplate) throws Exception {
        super(pathToTemplate, MediaEntityExporter.TemplateType.MOVIE);
    }

    @Override
    public <T extends MediaEntity> void export(List<T> moviesToExport, Path exportDir) throws Exception {
        Path listExportFile;
        LOGGER.info("preparing movie export; using {}", (Object)this.properties.getProperty("name"));
        if (this.cancel) {
            return;
        }
        this.engine.registerNamedRenderer((NamedRenderer)new NamedDateRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedNumberRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedUpperCaseRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedFirstCharacterRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new MovieFilenameRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new MovieArtworkCopyRenderer(exportDir));
        this.engine.registerNamedRenderer((NamedRenderer)new NamedFilesizeRenderer());
        if (!Files.exists(exportDir, new LinkOption[0])) {
            Files.createDirectories(exportDir, new FileAttribute[0]);
        }
        if ((listExportFile = exportDir.resolve("movielist." + this.fileExtension)) == null) {
            throw new FileNotFoundException("error creating movie list file");
        }
        LOGGER.info("generating movie list");
        Utils.deleteFileSafely(listExportFile);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("movies", new ArrayList<T>(moviesToExport));
        String output = this.engine.transform(this.listTemplate, root);
        Utils.writeStringToFile(listExportFile, output);
        LOGGER.info("movie list generated: {}", (Object)listExportFile);
        if (StringUtils.isNotBlank((CharSequence)this.detailTemplate)) {
            Path detailsDir = exportDir.resolve("movies");
            try {
                Files.createDirectory(detailsDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                LOGGER.debug("Folder already exists...");
            }
            for (MediaEntity me : moviesToExport) {
                if (this.cancel) {
                    return;
                }
                Movie movie = (Movie)me;
                LOGGER.debug("processing movie {}", (Object)movie.getTitle());
                String detailFilename = MovieRenamer.createDestinationForFilename(MovieModuleManager.SETTINGS.getRenamerFilename(), movie);
                if (StringUtils.isBlank((CharSequence)detailFilename)) {
                    detailFilename = movie.getVideoBasenameWithoutStacking();
                }
                Path detailsExportFile = detailsDir.resolve(detailFilename + "." + this.fileExtension);
                root = new HashMap();
                root.put("movie", movie);
                output = this.engine.transform(this.detailTemplate, root);
                Utils.writeStringToFile(detailsExportFile, output);
            }
            LOGGER.info("movie detail pages generated: {}", (Object)exportDir);
        }
        if (this.cancel) {
            return;
        }
        try {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.templateDir);
            Object object = null;
            try {
                for (Path path : directoryStream) {
                    if (Utils.isRegularFile(path)) {
                        if (path.getFileName().toString().endsWith(".jmte") || path.getFileName().toString().endsWith("template.conf")) continue;
                        Files.copy(path, exportDir.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    Utils.copyDirectoryRecursive(path, exportDir.resolve(path.getFileName()));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (directoryStream != null) {
                    if (object != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        directoryStream.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error("could not copy resources: ", (Throwable)ex);
        }
    }

    private static String getMovieFilename(Movie movie) {
        String filename = MovieRenamer.createDestinationForFilename(MovieModuleManager.SETTINGS.getRenamerFilename(), movie);
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            return filename;
        }
        filename = MovieRenamer.createDestinationForFilename("${title} ${- ,edition,} (${year}) ${videoFormat} ${audioCodec}", movie);
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            return filename;
        }
        return movie.getDbId().toString();
    }

    private static class MovieArtworkCopyRenderer
    extends MediaEntityExporter.ArtworkCopyRenderer {
        public MovieArtworkCopyRenderer(Path pathToExport) {
            super(pathToExport);
        }

        public Class<?>[] getSupportedClasses() {
            return new Class[]{Movie.class};
        }

        public String render(Object o, String pattern, Locale locale, Map<String, Object> model) {
            if (o instanceof Movie) {
                Movie movie = (Movie)o;
                Map<String, Object> parameters = this.parseParameters(pattern);
                MediaFile mf = movie.getArtworkMap().get(parameters.get("type"));
                if (mf == null || !mf.isGraphic()) {
                    if (StringUtils.isNotBlank((CharSequence)((String)parameters.get("default")))) {
                        return (String)parameters.get("default");
                    }
                    return "";
                }
                String filename = MovieExporter.getMovieFilename(movie) + "-" + (Object)((Object)mf.getType());
                Path imageDir = StringUtils.isNotBlank((CharSequence)((String)parameters.get("destination"))) ? this.pathToExport.resolve((String)parameters.get("destination")) : this.pathToExport;
                try {
                    if (!Files.exists(imageDir, new LinkOption[0])) {
                        Files.createDirectory(imageDir, new FileAttribute[0]);
                    }
                    if (parameters.get("thumb") == Boolean.TRUE) {
                        filename = filename + ".thumb." + FilenameUtils.getExtension((String)mf.getFilename());
                        int width = 150;
                        if (parameters.get("width") != null) {
                            width = (Integer)parameters.get("width");
                        }
                        InputStream is = ImageUtils.scaleImage(mf.getFileAsPath(), width);
                        Files.copy(is, imageDir.resolve(filename), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        filename = filename + "." + FilenameUtils.getExtension((String)mf.getFilename());
                        Files.copy(mf.getFileAsPath(), imageDir.resolve(filename), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("could not copy artwork file: ", (Throwable)e);
                    if (StringUtils.isNotBlank((CharSequence)((String)parameters.get("default")))) {
                        return (String)parameters.get("default");
                    }
                    return "";
                }
                if (parameters.get("escape") == Boolean.TRUE) {
                    try {
                        filename = URLEncoder.encode(filename, "UTF-8").replace("+", "%20");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return filename;
            }
            return "";
        }
    }

    private static class MovieFilenameRenderer
    implements NamedRenderer {
        private MovieFilenameRenderer() {
        }

        public RenderFormatInfo getFormatInfo() {
            return null;
        }

        public String getName() {
            return "filename";
        }

        public Class<?>[] getSupportedClasses() {
            return new Class[]{Movie.class};
        }

        public String render(Object o, String pattern, Locale locale, Map<String, Object> model) {
            if (o instanceof Movie) {
                Movie movie = (Movie)o;
                Map<Object, Object> parameters = new HashMap();
                if (pattern != null) {
                    parameters = this.parseParameters(pattern);
                }
                String filename = MovieExporter.getMovieFilename(movie);
                if (parameters.get("escape") == Boolean.TRUE) {
                    try {
                        filename = URLEncoder.encode(filename, "UTF-8").replace("+", "%20");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return filename;
            }
            return null;
        }

        private Map<String, Object> parseParameters(String parameters) {
            String[] details;
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            block8: for (String detail : details = parameters.split(",")) {
                String key = "";
                String value = "";
                try {
                    String[] d = detail.split("=");
                    key = d[0].trim();
                    value = d[1].trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) continue;
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "escape": {
                        parameterMap.put(key, Boolean.parseBoolean(value));
                        continue block8;
                    }
                }
            }
            return parameterMap;
        }
    }
}

