/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.jmte;

import com.floreysoft.jmte.DefaultModelAdaptor;
import com.floreysoft.jmte.ErrorHandler;
import com.floreysoft.jmte.ModelBuilder;
import com.floreysoft.jmte.message.ErrorMessage;
import com.floreysoft.jmte.token.Token;
import com.floreysoft.jmte.util.Util;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinymediamanager.scraper.DynaEnum;

public class TmmModelAdaptor
extends DefaultModelAdaptor {
    private static final String ERROR_STRING = "";

    protected Object getIndexFromArray(Object array, String arrayIndex, ErrorHandler errorHandler, Token token) {
        if (array == null) {
            errorHandler.error(ErrorMessage.NOT_ARRAY, token, new ModelBuilder("array", (Object)"[null]").build());
            return ERROR_STRING;
        }
        List arrayAsList = Util.arrayAsList((Object)array);
        try {
            if (arrayAsList != null) {
                try {
                    if (arrayIndex.equalsIgnoreCase("last")) {
                        if (!arrayAsList.isEmpty()) {
                            int index = arrayAsList.size() - 1;
                            return arrayAsList.get(index);
                        }
                        if (array != ERROR_STRING) {
                            errorHandler.error(ErrorMessage.INDEX_OUT_OF_BOUNDS, token, new ModelBuilder("arrayIndex", (Object)arrayIndex, "array", (Object)array.toString()).build());
                        }
                        return ERROR_STRING;
                    }
                    if (arrayIndex.contains(",")) {
                        String[] interval = arrayIndex.split(",");
                        int start = Integer.parseInt(interval[0]);
                        int end = start + Integer.parseInt(interval[1]);
                        ArrayList returnArray = new ArrayList();
                        for (int i = start; i < end && i < arrayAsList.size(); ++i) {
                            returnArray.add(arrayAsList.get(i));
                        }
                        return returnArray;
                    }
                    int index = Integer.parseInt(arrayIndex);
                    return arrayAsList.get(index);
                }
                catch (NumberFormatException nfe) {
                    if (array != ERROR_STRING) {
                        errorHandler.error(ErrorMessage.INVALID_INDEX, token, new ModelBuilder("arrayIndex", (Object)arrayIndex, "array", (Object)array.toString()).build());
                    }
                    return ERROR_STRING;
                }
            }
            if (array instanceof String && array != ERROR_STRING) {
                if (arrayIndex.contains(",")) {
                    String[] interval = arrayIndex.split(",");
                    int start = Integer.parseInt(interval[0]);
                    int end = start + Integer.parseInt(interval[1]);
                    return array.toString().substring(start, end);
                }
                int index = Integer.parseInt(arrayIndex);
                return array.toString().substring(index, index + 1);
            }
            if (array != ERROR_STRING) {
                errorHandler.error(ErrorMessage.NOT_ARRAY, token, new ModelBuilder("array", (Object)array.toString()).build());
            }
            return array;
        }
        catch (IndexOutOfBoundsException e) {
            return ERROR_STRING;
        }
    }

    protected Object getPropertyValue(Object o, String propertyName) {
        try {
            Field field;
            Method[] declaredMethods;
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                if (propertyName.equals("key")) {
                    return entry.getKey();
                }
                if (propertyName.equals("value")) {
                    return entry.getValue();
                }
            }
            boolean valueSet = false;
            Object value = null;
            Member member = null;
            Class<?> clazz = o.getClass();
            HashMap<String, Member> members = (HashMap<String, Member>)this.cache.get(clazz);
            if (members == null) {
                members = new HashMap<String, Member>();
                this.cache.put(clazz, members);
            } else {
                member = (Member)members.get(propertyName);
                if (member != null) {
                    if (member.getClass() == Method.class) {
                        return ((Method)member).invoke(o, new Object[0]);
                    }
                    if (member.getClass() == Field.class) {
                        return ((Field)member).get(o);
                    }
                }
            }
            String suffix = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            for (Method method : declaredMethods = clazz.getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals("get" + suffix) && !method.getName().equals("is" + suffix) && (!(o instanceof Enum) && !(o instanceof DynaEnum) || !method.getName().equals(propertyName)) || method.getParameterTypes().length != 0) continue;
                value = method.invoke(o, (Object[])null);
                valueSet = true;
                member = method;
                break;
            }
            if (!valueSet && Modifier.isPublic((field = clazz.getField(propertyName)).getModifiers())) {
                value = field.get(o);
                member = field;
                valueSet = true;
            }
            if (valueSet) {
                members.put(propertyName, member);
            }
            return value;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

