/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.DynaEnum;

public class MediaSource
extends DynaEnum<MediaSource> {
    private static final Comparator<MediaSource> COMPARATOR = new MediaSourceComparator();
    public static final MediaSource UHD_BLURAY = new MediaSource("UHD_BLURAY", 0, "UHD Blu-ray", "(uhd|ultrahd)[ .\\-]?(bluray|blueray|bdrip|brrip|dbrip|bd25|bd50|bdmv|blu\\-ray)");
    public static final MediaSource BLURAY = new MediaSource("BLURAY", 2, "Blu-ray", "(bluray|blueray|bdrip|brrip|dbrip|bd25|bd50|bdmv|blu\\-ray)");
    public static final MediaSource DVD = new MediaSource("DVD", 4, "DVD", "(dvd|video_ts|dvdrip|dvdr)");
    public static final MediaSource HDDVD = new MediaSource("HDDVD", 6, "HDDVD", "(hddvd|hddvdrip)");
    public static final MediaSource TV = new MediaSource("TV", 8, "TV", "(hdtv|pdtv|dsr|dtb|dtt|dttv|dtv|hdtvrip|tvrip|dvbrip)");
    public static final MediaSource VHS = new MediaSource("VHS", 10, "VHS", "(vhs|vhsrip)");
    public static final MediaSource LASERDISC = new MediaSource("LASERDISC", 12, "LaserDisc", "(laserdisc|ldrip)");
    public static final MediaSource D_VHS = new MediaSource("D_VHS", 14, "D-VHS");
    public static final MediaSource HDRIP = new MediaSource("HDRIP", 5, "HDRip", "(hdrip)");
    public static final MediaSource CAM = new MediaSource("CAM", 6, "Cam", "(cam)");
    public static final MediaSource TS = new MediaSource("TS", 7, "Telesync", "(ts|telesync|hdts|ht\\-ts)");
    public static final MediaSource TC = new MediaSource("TC", 8, "Telecine", "(tc|telecine|hdtc|ht\\-tc)");
    public static final MediaSource DVDSCR = new MediaSource("DVDSCR", 9, "DVD Screener", "(dvdscr)");
    public static final MediaSource R5 = new MediaSource("R5", 10, "R5", "(r5)");
    public static final MediaSource WEBRIP = new MediaSource("WEBRIP", 11, "Webrip", "(webrip)");
    public static final MediaSource WEB_DL = new MediaSource("WEB_DL", 12, "Web-DL", "(web-dl|webdl)");
    public static final MediaSource STREAM = new MediaSource("STREAM", 13, "Stream");
    public static final MediaSource UNKNOWN = new MediaSource("UNKNOWN", 14, "");
    private static final String START_TOKEN = "[ _\\,\\.\\(\\)\\[\\]\\-]";
    private static final String END_TOKEN = "([ _\\,\\.\\(\\)\\[\\]\\-]|$)";
    private final String title;
    private final Pattern pattern;

    private MediaSource(String enumName, int ordinal, String title) {
        this(enumName, ordinal, title, "");
    }

    private MediaSource(String enumName, int ordinal, String title, String pattern) {
        super(enumName, ordinal);
        this.title = title;
        this.pattern = StringUtils.isNotBlank((CharSequence)pattern) ? Pattern.compile(START_TOKEN + pattern + END_TOKEN, 2) : null;
        this.addElement();
    }

    @Override
    public String toString() {
        return this.title;
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    public static MediaSource[] values() {
        MediaSource[] mediaSources = MediaSource.values(MediaSource.class);
        Arrays.sort(mediaSources, COMPARATOR);
        return mediaSources;
    }

    @JsonCreator
    public static MediaSource getMediaSource(String name) {
        for (MediaSource mediaSource : MediaSource.values()) {
            if (mediaSource.name().equals(name)) {
                return mediaSource;
            }
            if (!mediaSource.title.equalsIgnoreCase(name)) continue;
            return mediaSource;
        }
        return new MediaSource(name, MediaSource.values().length, name, "");
    }

    public static MediaSource parseMediaSource(String filename) {
        String fn = filename.toLowerCase(Locale.ROOT);
        String ext = FilenameUtils.getExtension((String)fn);
        if (MediaSource.UHD_BLURAY.pattern.matcher(filename).find()) {
            return UHD_BLURAY;
        }
        for (MediaSource mediaSource : MediaSource.values()) {
            if (mediaSource.pattern == null || !mediaSource.pattern.matcher(filename).find()) continue;
            return mediaSource;
        }
        if (ext.equals("strm")) {
            return STREAM;
        }
        return UNKNOWN;
    }

    public static void addListener(DynaEnum.DynaEnumEventListener listener) {
        MediaSource.addListener(MediaSource.class, listener);
    }

    public static void removeListener(DynaEnum.DynaEnumEventListener listener) {
        MediaSource.removeListener(MediaSource.class, listener);
    }

    private static class MediaSourceComparator
    implements Comparator<MediaSource> {
        private MediaSourceComparator() {
        }

        @Override
        public int compare(MediaSource o1, MediaSource o2) {
            if (o1.toString() == null && o2.toString() == null) {
                return 0;
            }
            if (o1.toString() == null) {
                return 1;
            }
            if (o2.toString() == null) {
                return -1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

