/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.util.ResourceBundle;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.scraper.util.LanguageUtils;

public enum LanguageStyle {
    ISO2,
    ISO3T,
    ISO3B,
    LANG_EN,
    LANG_LOCALIZED;

    private static final ResourceBundle BUNDLE;

    public String toString() {
        try {
            return BUNDLE.getString("Settings.renamer.language." + this.name());
        }
        catch (Exception e) {
            return this.name();
        }
    }

    public static String getLanguageCodeForStyle(String language, LanguageStyle style) {
        switch (style) {
            case ISO2: {
                return LanguageUtils.getIso2LanguageFromLocalizedString(language);
            }
            case ISO3T: {
                return LanguageUtils.getIso3LanguageFromLocalizedString(language);
            }
            case ISO3B: {
                return LanguageUtils.getIso3BLanguageFromLocalizedString(language);
            }
            case LANG_EN: {
                return LanguageUtils.getEnglishLanguageNameFromLocalizedString(language);
            }
            case LANG_LOCALIZED: {
                return LanguageUtils.getLocalizedLanguageNameFromLocalizedString(language);
            }
        }
        return language;
    }

    static {
        BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    }
}

