/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.thirdparty.ImageLoader;

public class ImageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageUtils.class);

    public static InputStream scaleImage(byte[] imageBytes, int width) throws IOException {
        BufferedImage originalImage;
        try {
            originalImage = ImageUtils.createImage(imageBytes);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        Point size = new Point();
        size.x = width;
        size.y = size.x * originalImage.getHeight() / originalImage.getWidth();
        BufferedImage scaledImage = Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        originalImage = null;
        ImageWriter imgWrtr = null;
        ImageWriteParam imgWrtrPrm = null;
        if (ImageUtils.hasTransparentPixels(scaledImage)) {
            imgWrtr = ImageIO.getImageWritersByFormatName("png").next();
            imgWrtrPrm = imgWrtr.getDefaultWriteParam();
        } else {
            BufferedImage rgb = new BufferedImage(scaledImage.getWidth(), scaledImage.getHeight(), 1);
            ColorConvertOp xformOp = new ColorConvertOp(null);
            xformOp.filter(scaledImage, rgb);
            imgWrtr = ImageIO.getImageWritersByFormatName("jpg").next();
            imgWrtrPrm = imgWrtr.getDefaultWriteParam();
            imgWrtrPrm.setCompressionMode(2);
            imgWrtrPrm.setCompressionQuality(0.8f);
            scaledImage = rgb;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream output = ImageIO.createImageOutputStream(baos);
        imgWrtr.setOutput(output);
        IIOImage outputImage = new IIOImage(scaledImage, null, null);
        imgWrtr.write(null, outputImage, imgWrtrPrm);
        imgWrtr.dispose();
        scaledImage = null;
        byte[] bytes = baos.toByteArray();
        output.flush();
        output.close();
        baos.close();
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream scaleImage(Path file, int width) throws IOException {
        BufferedImage originalImage;
        try {
            originalImage = ImageUtils.createImage(file);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        Point size = new Point();
        size.x = width;
        size.y = size.x * originalImage.getHeight() / originalImage.getWidth();
        BufferedImage scaledImage = Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        originalImage = null;
        ImageWriter imgWrtr = null;
        ImageWriteParam imgWrtrPrm = null;
        if (ImageUtils.hasTransparentPixels(scaledImage)) {
            imgWrtr = ImageIO.getImageWritersByFormatName("png").next();
            imgWrtrPrm = imgWrtr.getDefaultWriteParam();
        } else {
            BufferedImage rgb = new BufferedImage(scaledImage.getWidth(), scaledImage.getHeight(), 1);
            ColorConvertOp xformOp = new ColorConvertOp(null);
            xformOp.filter(scaledImage, rgb);
            imgWrtr = ImageIO.getImageWritersByFormatName("jpg").next();
            imgWrtrPrm = imgWrtr.getDefaultWriteParam();
            imgWrtrPrm.setCompressionMode(2);
            imgWrtrPrm.setCompressionQuality(0.8f);
            scaledImage = rgb;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream output = ImageIO.createImageOutputStream(baos);
        imgWrtr.setOutput(output);
        IIOImage outputImage = new IIOImage(scaledImage, null, null);
        imgWrtr.write(null, outputImage, imgWrtrPrm);
        imgWrtr.dispose();
        scaledImage = null;
        byte[] bytes = baos.toByteArray();
        output.flush();
        output.close();
        baos.close();
        return new ByteArrayInputStream(bytes);
    }

    static boolean hasTransparentPixels(BufferedImage image) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int pixel = image.getRGB(x, y);
                if (pixel >> 24 != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static Point calculateSize(int maxWidth, int maxHeight, int originalWidth, int originalHeight, boolean respectFactor) {
        Point size = new Point();
        if (respectFactor) {
            size.y = maxHeight;
            size.x = (int)((double)size.y * (double)originalWidth / (double)originalHeight);
            if (size.x > maxWidth) {
                size.x = maxWidth;
                size.y = (int)((double)size.x * (double)originalHeight / (double)originalWidth);
            }
        } else {
            size.x = maxWidth;
            size.y = maxHeight;
        }
        return size;
    }

    public static BufferedImage createImage(byte[] imageData) throws IOException {
        try {
            return ImageUtils.createImage(Toolkit.getDefaultToolkit().createImage(imageData));
        }
        catch (Exception e) {
            try (ByteArrayInputStream bis = new ByteArrayInputStream(imageData);){
                BufferedImage bufferedImage = ImageIO.read(bis);
                return bufferedImage;
            }
        }
    }

    public static BufferedImage createImage(Path file) throws IOException {
        try {
            return ImageUtils.createImage(Toolkit.getDefaultToolkit().createImage(file.toFile().getAbsolutePath()));
        }
        catch (Exception e) {
            return ImageIO.read(file.toFile());
        }
    }

    public static BufferedImage createImage(Image img) {
        return ImageLoader.createImage(img);
    }

    public static Path downloadImage(String urlAsString, Path destinationFolder, String filename) throws InterruptedException, IOException {
        return ImageUtils.downloadImage(urlAsString, destinationFolder, filename, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path downloadImage(String urlAsString, Path destinationFolder, String filename, boolean rescale, int newWidth) throws InterruptedException, IOException {
        Path tempFile;
        Path destFile;
        block74: {
            String newUrl;
            Path file;
            if (FilenameUtils.getExtension((String)filename).equalsIgnoreCase("JPEG")) {
                filename = FilenameUtils.getBaseName((String)filename) + ".jpg";
            }
            destFile = destinationFolder.resolve(filename);
            if (urlAsString.startsWith("file:") && (file = Paths.get(newUrl = urlAsString.replace("file:/", ""), new String[0])).equals(destFile)) {
                return destFile;
            }
            LOGGER.debug("downloading {} to {}", (Object)urlAsString, (Object)destFile);
            tempFile = null;
            try {
                block73: {
                    Url url;
                    long timestamp = System.currentTimeMillis();
                    try {
                        Path tempFolder = Paths.get(Utils.getTempFolder(), new String[0]);
                        if (!Files.exists(tempFolder, new LinkOption[0])) {
                            Files.createDirectory(tempFolder, new FileAttribute[0]);
                        }
                        tempFile = tempFolder.resolve(filename + "." + timestamp + ".part");
                    }
                    catch (Exception e) {
                        LOGGER.debug("could not write to temp folder: {}", (Object)e.getMessage());
                        tempFile = destFile.resolveSibling(filename + "." + timestamp + ".part");
                    }
                    try {
                        url = new Url(urlAsString);
                    }
                    catch (Exception e) {
                        LOGGER.error("downloading {} - {}", (Object)urlAsString, (Object)e.getMessage());
                        throw e;
                    }
                    if (!rescale || newWidth == 0) {
                        try (InputStream is = url.getInputStreamWithRetry(5);
                             FileOutputStream outputStream = new FileOutputStream(tempFile.toFile());){
                            IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                            Utils.flushFileOutputStreamToDisk(outputStream);
                            break block73;
                        }
                    }
                    try (InputStream is = url.getInputStreamWithRetry(5);
                         InputStream scaledIs = ImageUtils.scaleImage(IOUtils.toByteArray((InputStream)is), newWidth);
                         FileOutputStream outputStream = new FileOutputStream(tempFile.toFile());){
                        IOUtils.copy((InputStream)scaledIs, (OutputStream)outputStream);
                        Utils.flushFileOutputStreamToDisk(outputStream);
                    }
                }
                if (!Files.exists(tempFile, new LinkOption[0]) || Files.size(tempFile) == 0L) {
                    FileUtils.deleteQuietly((File)tempFile.toFile());
                    throw new IOException("0byte file downloaded: " + filename);
                }
                Utils.deleteFileSafely(destFile);
                if (Utils.moveFileSafe(tempFile, destFile)) break block74;
                throw new IOException("renaming temp file failed: " + filename);
            }
            catch (Throwable throwable) {
                if (tempFile != null && Files.exists(tempFile, new LinkOption[0])) {
                    Utils.deleteFileSafely(tempFile);
                }
                throw throwable;
            }
        }
        if (tempFile != null && Files.exists(tempFile, new LinkOption[0])) {
            Utils.deleteFileSafely(tempFile);
        }
        return destFile;
    }
}

