/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class AbstractModelObject {
    private final PropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this, true);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(listener);
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.removePropertyChangeListener(propertyName, listener);
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        try {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        try {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        try {
            if (this.propertyChangeSupport.getPropertyChangeListeners().length > 0) {
                this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
            }
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        try {
            if (this.propertyChangeSupport.getPropertyChangeListeners().length > 0) {
                this.propertyChangeSupport.firePropertyChange(evt);
            }
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }
}

