/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.Settings;

public class Globals {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("tmm.debug", "false"));
    public static final String DATA_FOLDER;
    public static final String CACHE_FOLDER;
    public static final String BACKUP_FOLDER;
    public static final String LOG_FOLDER;
    public static final Settings settings;

    public static boolean isDebug() {
        return DEBUG;
    }

    public static boolean isRunningJavaWebStart() {
        boolean hasJNLP = false;
        try {
            Class.forName("javax.jnlp.ServiceManager");
            hasJNLP = true;
        }
        catch (ClassNotFoundException ex) {
            hasJNLP = false;
        }
        return hasJNLP;
    }

    public static boolean isRunningWebSwing() {
        return System.getProperty("webswing.classPath") != null;
    }

    static {
        String dataFolder = System.getProperty("tmm.datafolder");
        String cacheFolder = System.getProperty("tmm.cachefolder");
        String backupFolder = System.getProperty("tmm.backupfolder");
        String logFolder = System.getProperty("tmm.logfolder");
        String contentFolder = System.getProperty("tmm.contentfolder");
        DATA_FOLDER = StringUtils.isNotBlank((CharSequence)dataFolder) ? dataFolder : (StringUtils.isNotBlank((CharSequence)contentFolder) ? contentFolder + "/data" : "data");
        CACHE_FOLDER = StringUtils.isNotBlank((CharSequence)cacheFolder) ? cacheFolder : (StringUtils.isNotBlank((CharSequence)contentFolder) ? contentFolder + "/cache" : "cache");
        BACKUP_FOLDER = StringUtils.isNotBlank((CharSequence)backupFolder) ? backupFolder : (StringUtils.isNotBlank((CharSequence)contentFolder) ? contentFolder + "/backup" : "backup");
        LOG_FOLDER = StringUtils.isNotBlank((CharSequence)logFolder) ? logFolder : (StringUtils.isNotBlank((CharSequence)contentFolder) ? contentFolder + "/logs" : "logs");
        settings = Settings.getInstance();
    }
}

