/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextPaneUI;
import javax.swing.text.JTextComponent;

public class BaseTextPaneUI
extends BasicTextPaneUI {
    private Border orgBorder = null;
    private FocusListener focusListener = null;

    public static ComponentUI createUI(JComponent c) {
        return new BaseTextPaneUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.updateBackground();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (JTattooUtilities.isMac()) {
            InputMap im = (InputMap)UIManager.get("TextPane.focusInputMap");
            int commandKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            im.put(KeyStroke.getKeyStroke(67, commandKey), "copy-to-clipboard");
            im.put(KeyStroke.getKeyStroke(86, commandKey), "paste-from-clipboard");
            im.put(KeyStroke.getKeyStroke(88, commandKey), "cut-to-clipboard");
            im.put(KeyStroke.getKeyStroke(39, 512), "caret-next-word");
            im.put(KeyStroke.getKeyStroke(37, 512), "caret-previous-word");
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            this.focusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (BaseTextPaneUI.this.getComponent() != null) {
                        BaseTextPaneUI.this.orgBorder = BaseTextPaneUI.this.getComponent().getBorder();
                        LookAndFeel laf = UIManager.getLookAndFeel();
                        if (laf instanceof AbstractLookAndFeel && BaseTextPaneUI.this.orgBorder instanceof UIResource) {
                            Border focusBorder = ((AbstractLookAndFeel)laf).getBorderFactory().getFocusFrameBorder();
                            BaseTextPaneUI.this.getComponent().setBorder(focusBorder);
                        }
                        BaseTextPaneUI.this.getComponent().invalidate();
                        BaseTextPaneUI.this.getComponent().repaint();
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (BaseTextPaneUI.this.getComponent() != null) {
                        if (BaseTextPaneUI.this.orgBorder instanceof UIResource) {
                            BaseTextPaneUI.this.getComponent().setBorder(BaseTextPaneUI.this.orgBorder);
                        }
                        BaseTextPaneUI.this.getComponent().invalidate();
                        BaseTextPaneUI.this.getComponent().repaint();
                    }
                }
            };
            this.getComponent().addFocusListener(this.focusListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void paintBackground(Graphics g) {
        g.setColor(this.getComponent().getBackground());
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && this.getComponent().hasFocus() && this.getComponent().isEditable()) {
            g.setColor(AbstractLookAndFeel.getTheme().getFocusBackgroundColor());
        }
        g.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
    }

    @Override
    protected void paintSafely(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        Object savedRenderingHint = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        super.paintSafely(g);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
        }
    }

    @Override
    protected void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("editable") || evt.getPropertyName().equals("enabled")) {
            this.updateBackground();
        }
        super.propertyChange(evt);
    }

    private void updateBackground() {
        JTextComponent c = this.getComponent();
        if (c.getBackground() instanceof UIResource) {
            if (!c.isEnabled() || !c.isEditable()) {
                c.setBackground(AbstractLookAndFeel.getDisabledBackgroundColor());
            } else {
                c.setBackground(AbstractLookAndFeel.getInputBackgroundColor());
            }
        }
    }
}

