/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.input.MouseEvent;

public abstract class ComboBoxPopupControl<T>
extends ComboBoxBaseSkin<T> {
    private PopupControl popup;

    public ComboBoxPopupControl(ComboBoxBase<T> comboBoxBase, ComboBoxBaseBehavior comboBoxBaseBehavior) {
        super(comboBoxBase, comboBoxBaseBehavior);
    }

    protected abstract Node getPopupContent();

    protected PopupControl getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    @Override
    public void show() {
        if (this.getSkinnable() == null) {
            throw new IllegalStateException("ComboBox is null");
        }
        Node node = this.getPopupContent();
        if (node == null) {
            throw new IllegalStateException("Popup node is null");
        }
        if (this.getPopup().isShowing()) {
            return;
        }
        this.positionAndShowPopup();
    }

    @Override
    public void hide() {
        if (this.popup != null && this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    private Point2D getPrefPopupPosition() {
        return Utils.pointRelativeTo((Node)((Object)this.getSkinnable()), this.getPopupContent(), HPos.CENTER, VPos.BOTTOM, -7.0, -10.0, false);
    }

    private void positionAndShowPopup() {
        if (this.getPopup().getSkin() == null) {
            this.getScene().getRoot().impl_processCSS(true);
        }
        Point2D point2D = this.getPrefPopupPosition();
        this.getPopup().show(((ComboBoxBase)this.getSkinnable()).getScene().getWindow(), point2D.getX(), point2D.getY());
    }

    private void createPopup() {
        this.popup = new PopupControl(){
            {
                this.setSkin(new Skin(){

                    public Skinnable getSkinnable() {
                        return ComboBoxPopupControl.this.getSkinnable();
                    }

                    @Override
                    public Node getNode() {
                        return ComboBoxPopupControl.this.getPopupContent();
                    }

                    @Override
                    public void dispose() {
                    }
                });
            }
        };
        this.popup.getStyleClass().add("combo-box-popup");
        this.popup.setAutoHide(true);
        this.popup.setAutoFix(true);
        this.popup.setHideOnEscape(true);
        this.popup.setOnAutoHide(new EventHandler<Event>(){

            @Override
            public void handle(Event event) {
                ((ComboBoxBaseBehavior)ComboBoxPopupControl.this.getBehavior()).onAutoHide();
            }
        });
        this.popup.addEventHandler(MouseEvent.MOUSE_CLICKED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                ((ComboBoxBaseBehavior)ComboBoxPopupControl.this.getBehavior()).onAutoHide();
            }
        });
        InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                ComboBoxPopupControl.this.reconfigurePopup();
            }
        };
        ((ComboBoxBase)this.getSkinnable()).layoutXProperty().addListener(invalidationListener);
        ((ComboBoxBase)this.getSkinnable()).layoutYProperty().addListener(invalidationListener);
        ((ComboBoxBase)this.getSkinnable()).widthProperty().addListener(invalidationListener);
    }

    void reconfigurePopup() {
        if (!this.getPopup().isShowing()) {
            return;
        }
        Point2D point2D = this.getPrefPopupPosition();
        this.reconfigurePopup(point2D.getX(), point2D.getY(), this.getPopupContent().prefWidth(1.0), this.getPopupContent().prefHeight(1.0));
    }

    void reconfigurePopup(double d, double d2, double d3, double d4) {
        if (!this.getPopup().isShowing()) {
            return;
        }
        if (d > -1.0) {
            this.getPopup().setX(d);
        }
        if (d2 > -1.0) {
            this.getPopup().setY(d2);
        }
        if (d3 > -1.0) {
            this.getPopup().setMinWidth(d3);
        }
        if (d4 > -1.0) {
            this.getPopup().setMinHeight(d4);
        }
    }
}

