/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.addressing.WsaTubeHelper;
import com.sun.xml.internal.ws.addressing.WsaTubeHelperImpl;
import com.sun.xml.internal.ws.addressing.model.InvalidAddressingHeaderException;
import com.sun.xml.internal.ws.addressing.model.MissingAddressingHeaderException;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.developer.MemberSubmissionAddressingFeature;
import com.sun.xml.internal.ws.message.FaultDetailHeader;
import com.sun.xml.internal.ws.resources.AddressingMessages;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.SOAPBinding;

abstract class WsaTube
extends AbstractFilterTubeImpl {
    @NotNull
    protected final WSDLPort wsdlPort;
    protected final WSBinding binding;
    final WsaTubeHelper helper;
    @NotNull
    protected final AddressingVersion addressingVersion;
    protected final SOAPVersion soapVersion;
    private final boolean addressingRequired;
    private static final Logger LOGGER = Logger.getLogger(WsaTube.class.getName());

    public WsaTube(WSDLPort wSDLPort, WSBinding wSBinding, Tube tube) {
        super(tube);
        this.wsdlPort = wSDLPort;
        this.binding = wSBinding;
        this.addressingVersion = wSBinding.getAddressingVersion();
        this.soapVersion = wSBinding.getSOAPVersion();
        this.helper = this.getTubeHelper();
        this.addressingRequired = AddressingVersion.isRequired(wSBinding);
    }

    public WsaTube(WsaTube wsaTube, TubeCloner tubeCloner) {
        super(wsaTube, tubeCloner);
        this.wsdlPort = wsaTube.wsdlPort;
        this.binding = wsaTube.binding;
        this.helper = wsaTube.helper;
        this.addressingVersion = wsaTube.addressingVersion;
        this.soapVersion = wsaTube.soapVersion;
        this.addressingRequired = wsaTube.addressingRequired;
    }

    @Override
    @NotNull
    public NextAction processException(Throwable throwable) {
        return super.processException(throwable);
    }

    protected WsaTubeHelper getTubeHelper() {
        if (this.binding.isFeatureEnabled(AddressingFeature.class)) {
            return new WsaTubeHelperImpl(this.wsdlPort, null, this.binding);
        }
        if (this.binding.isFeatureEnabled(MemberSubmissionAddressingFeature.class)) {
            return new com.sun.xml.internal.ws.addressing.v200408.WsaTubeHelperImpl(this.wsdlPort, null, this.binding);
        }
        throw new WebServiceException(AddressingMessages.ADDRESSING_NOT_ENABLED(this.getClass().getSimpleName()));
    }

    protected Packet validateInboundHeaders(Packet packet) {
        FaultDetailHeader faultDetailHeader;
        SOAPFault sOAPFault;
        try {
            this.checkMessageAddressingProperties(packet);
            return packet;
        }
        catch (InvalidAddressingHeaderException invalidAddressingHeaderException) {
            LOGGER.log(Level.WARNING, this.addressingVersion.getInvalidMapText() + ", Problem header:" + invalidAddressingHeaderException.getProblemHeader() + ", Reason: " + invalidAddressingHeaderException.getSubsubcode(), invalidAddressingHeaderException);
            sOAPFault = this.helper.createInvalidAddressingHeaderFault(invalidAddressingHeaderException, this.addressingVersion);
            faultDetailHeader = new FaultDetailHeader(this.addressingVersion, this.addressingVersion.problemHeaderQNameTag.getLocalPart(), invalidAddressingHeaderException.getProblemHeader());
        }
        catch (MissingAddressingHeaderException missingAddressingHeaderException) {
            LOGGER.log(Level.WARNING, this.addressingVersion.getMapRequiredText() + ", Problem header:" + missingAddressingHeaderException.getMissingHeaderQName(), missingAddressingHeaderException);
            sOAPFault = this.helper.newMapRequiredFault(missingAddressingHeaderException);
            faultDetailHeader = new FaultDetailHeader(this.addressingVersion, this.addressingVersion.problemHeaderQNameTag.getLocalPart(), missingAddressingHeaderException.getMissingHeaderQName());
        }
        if (sOAPFault != null) {
            if (this.wsdlPort != null && packet.getMessage().isOneWay(this.wsdlPort)) {
                return packet.createServerResponse(null, this.wsdlPort, null, this.binding);
            }
            Message message = Messages.create(sOAPFault);
            if (this.soapVersion == SOAPVersion.SOAP_11) {
                message.getHeaders().add(faultDetailHeader);
            }
            return packet.createServerResponse(message, this.wsdlPort, null, this.binding);
        }
        return packet;
    }

    protected void checkMessageAddressingProperties(Packet packet) {
        this.checkCardinality(packet);
    }

    final boolean isAddressingEngagedOrRequired(Packet packet, WSBinding wSBinding) {
        if (AddressingVersion.isRequired(wSBinding)) {
            return true;
        }
        if (packet == null) {
            return false;
        }
        if (packet.getMessage() == null) {
            return false;
        }
        if (packet.getMessage().getHeaders() != null) {
            return false;
        }
        String string = packet.getMessage().getHeaders().getAction(this.addressingVersion, this.soapVersion);
        if (string == null) {
            return true;
        }
        return true;
    }

    protected void checkCardinality(Packet packet) {
        Message message = packet.getMessage();
        if (message == null) {
            if (this.addressingRequired) {
                throw new WebServiceException(AddressingMessages.NULL_MESSAGE());
            }
            return;
        }
        Iterator<Header> iterator = message.getHeaders().getHeaders(this.addressingVersion.nsUri, true);
        if (!iterator.hasNext()) {
            if (this.addressingRequired) {
                throw new MissingAddressingHeaderException(this.addressingVersion.actionTag, packet);
            }
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        QName qName = null;
        while (iterator.hasNext()) {
            Header header = iterator.next();
            if (!this.isInCurrentRole(header, this.binding)) continue;
            String string = header.getLocalPart();
            if (string.equals(this.addressingVersion.fromTag.getLocalPart())) {
                if (bl) {
                    qName = this.addressingVersion.fromTag;
                    break;
                }
                bl = true;
                continue;
            }
            if (string.equals(this.addressingVersion.toTag.getLocalPart())) {
                if (bl2) {
                    qName = this.addressingVersion.toTag;
                    break;
                }
                bl2 = true;
                continue;
            }
            if (string.equals(this.addressingVersion.replyToTag.getLocalPart())) {
                if (bl3) {
                    qName = this.addressingVersion.replyToTag;
                    break;
                }
                bl3 = true;
                try {
                    header.readAsEPR(this.addressingVersion);
                    continue;
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new WebServiceException(AddressingMessages.REPLY_TO_CANNOT_PARSE(), xMLStreamException);
                }
            }
            if (string.equals(this.addressingVersion.faultToTag.getLocalPart())) {
                if (bl4) {
                    qName = this.addressingVersion.faultToTag;
                    break;
                }
                bl4 = true;
                try {
                    header.readAsEPR(this.addressingVersion);
                    continue;
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new WebServiceException(AddressingMessages.FAULT_TO_CANNOT_PARSE(), xMLStreamException);
                }
            }
            if (string.equals(this.addressingVersion.actionTag.getLocalPart())) {
                if (bl5) {
                    qName = this.addressingVersion.actionTag;
                    break;
                }
                bl5 = true;
                continue;
            }
            if (string.equals(this.addressingVersion.messageIDTag.getLocalPart())) {
                if (bl6) {
                    qName = this.addressingVersion.messageIDTag;
                    break;
                }
                bl6 = true;
                continue;
            }
            if (string.equals(this.addressingVersion.relatesToTag.getLocalPart())) {
                bl7 = true;
                continue;
            }
            if (string.equals(this.addressingVersion.faultDetailTag.getLocalPart())) continue;
            System.err.println(AddressingMessages.UNKNOWN_WSA_HEADER());
        }
        if (qName != null) {
            throw new InvalidAddressingHeaderException(qName, this.addressingVersion.invalidCardinalityTag);
        }
        boolean bl8 = bl5;
        if (bl8 || this.addressingRequired) {
            this.checkMandatoryHeaders(packet, bl5, bl2, bl3, bl4, bl6, bl7);
        }
    }

    final boolean isInCurrentRole(Header header, WSBinding wSBinding) {
        if (wSBinding == null) {
            return true;
        }
        return ((SOAPBinding)((Object)wSBinding)).getRoles().contains(header.getRole(this.soapVersion));
    }

    protected final WSDLBoundOperation getWSDLBoundOperation(Packet packet) {
        if (this.wsdlPort == null) {
            return null;
        }
        QName qName = packet.getWSDLOperation();
        if (qName != null) {
            return this.wsdlPort.getBinding().get(qName);
        }
        return null;
    }

    protected void validateSOAPAction(Packet packet) {
        String string = packet.getMessage().getHeaders().getAction(this.addressingVersion, this.soapVersion);
        if (string == null) {
            throw new WebServiceException(AddressingMessages.VALIDATION_SERVER_NULL_ACTION());
        }
        if (packet.soapAction != null && !packet.soapAction.equals("\"\"") && !packet.soapAction.equals("\"" + string + "\"")) {
            throw new InvalidAddressingHeaderException(this.addressingVersion.actionTag, this.addressingVersion.actionMismatchTag);
        }
    }

    protected abstract void validateAction(Packet var1);

    protected void checkMandatoryHeaders(Packet packet, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (!bl) {
            throw new MissingAddressingHeaderException(this.addressingVersion.actionTag, packet);
        }
        this.validateSOAPAction(packet);
    }
}

